/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.internal;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.slaves.Cloud;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsComputer;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import org.jclouds.compute.domain.NodeMetadata;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

@Extension
public class PhoneHomeWebHook
implements UnprotectedRootAction {
    public static final String URLNAME = "jclouds-phonehome";
    private static final Logger LOGGER = Logger.getLogger(PhoneHomeWebHook.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URLNAME;
    }

    @RequirePOST
    public void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) {
        String hostName = req.getParameter("hostname");
        if (null == hostName) {
            throw new IllegalArgumentException("Not intended to be browsed interactively (must specify hostname parameter)");
        }
        LOGGER.info("Received POST from " + hostName);
        try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
            for (Computer c : Jenkins.get().getComputers()) {
                NodeMetadata nmd;
                JCloudsSlave slave;
                if (!JCloudsComputer.class.isInstance(c) || null == (slave = (JCloudsSlave)((JCloudsComputer)c).getNode()) || null == (nmd = slave.getNodeMetaData()) || !nmd.getHostname().equals(hostName)) continue;
                slave.setWaitPhoneHome(false);
                return;
            }
            for (Cloud c : Jenkins.get().clouds) {
                if (!JCloudsCloud.class.isInstance(c) || !((JCloudsCloud)c).phoneHomeNotify(hostName)) continue;
                return;
            }
        }
    }

    public static PhoneHomeWebHook get() {
        return (PhoneHomeWebHook)Jenkins.get().getExtensionList(RootAction.class).get(PhoneHomeWebHook.class);
    }
}

