/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.internal;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.RootAction;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsComputer;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

@Extension
public class JnlpProvisionWebHook
implements UnprotectedRootAction {
    public static final String URLNAME = "jclouds-jnlp-provision";
    private static final Logger LOGGER = Logger.getLogger(JnlpProvisionWebHook.class.getName());

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URLNAME;
    }

    @RequirePOST
    public void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) {
        String rHost = req.getRemoteHost();
        String rAddr = req.getRemoteAddr();
        String hostName = req.getParameter("hostname");
        String auth = req.getParameter("auth");
        if (null == auth) {
            rsp.setStatus(401);
            LOGGER.warning(String.format(rHost, rAddr));
            return;
        }
        if (null == hostName) {
            rsp.setStatus(400);
            LOGGER.warning(String.format(rHost, rAddr));
            return;
        }
        LOGGER.info(String.format(rHost, rAddr, hostName));
        try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
            for (Computer c : Jenkins.get().getComputers()) {
                JCloudsSlave slave;
                if (!JCloudsComputer.class.isInstance(c) || null == (slave = (JCloudsSlave)((JCloudsComputer)c).getNode()) || !slave.getNodeName().equals(hostName)) continue;
                String result = slave.handleJnlpProvisioning(auth);
                if (result.isEmpty()) {
                    rsp.setStatus(403);
                    return;
                }
                ByteArrayInputStream str = new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8));
                try {
                    rsp.serveFile(req, (InputStream)str, 0L, (long)result.length(), "response.json");
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "Could not send response:", x);
                }
                return;
            }
            LOGGER.warning("hostName not found " + hostName);
        }
    }

    public static JnlpProvisionWebHook get() {
        return (JnlpProvisionWebHook)Jenkins.get().getExtensionList(RootAction.class).get(JnlpProvisionWebHook.class);
    }
}

