/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.internal;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import jenkins.plugins.jclouds.internal.CredentialsHelper;

public class CryptoHelper {
    private static final byte[] LF = new byte[]{10};
    private final Cipher cipher;
    private final KeyPair keypair;
    private final int decryptBlockLen;

    public CryptoHelper(@CheckForNull String id) {
        if (null == id) {
            throw new IllegalStateException("Could not get NULL credential");
        }
        try {
            this.keypair = CredentialsHelper.getKeyPairFromCredential(id);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not get keypair from credential: " + e.toString());
        }
        if (this.keypair.getPrivate() instanceof RSAPrivateKey) {
            RSAKey k = (RSAKey)((Object)this.keypair.getPublic());
            int bitLen = k.getModulus().bitLength();
            this.decryptBlockLen = bitLen / 8 + (bitLen % 8 != 0 ? 1 : 0);
            try {
                this.cipher = Cipher.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new IllegalStateException("Could not get RSA cipher: " + e.toString());
            }
        } else {
            throw new IllegalStateException("Invalid key type " + this.keypair.getPrivate().toString());
        }
    }

    public String encrypt(String plaintext) {
        try {
            this.cipher.init(1, this.keypair.getPublic());
            byte[] crypted = this.blockCipher(plaintext.getBytes(StandardCharsets.UTF_8), 1);
            return Base64.getMimeEncoder(80, LF).encodeToString(crypted);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Could not encrypt: " + e.toString());
        }
    }

    public String decrypt(String base64) {
        try {
            this.cipher.init(2, this.keypair.getPrivate());
            byte[] crypted = Base64.getMimeDecoder().decode(base64);
            return new String(this.blockCipher(crypted, 2), StandardCharsets.UTF_8);
        }
        catch (InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Could not decrypt: " + e.toString());
        }
    }

    private byte[] blockCipher(byte[] bytes, int mode) throws IllegalBlockSizeException, BadPaddingException {
        byte[] result = new byte[]{};
        int blocklen = mode == 1 ? 100 : this.decryptBlockLen;
        byte[] buffer = new byte[blocklen];
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0 && i % blocklen == 0) {
                result = this.concat(result, this.cipher.doFinal(buffer));
                int newlen = blocklen;
                if (i + blocklen > bytes.length) {
                    newlen = bytes.length - i;
                }
                buffer = new byte[newlen];
            }
            buffer[i % blocklen] = bytes[i];
        }
        return this.concat(result, this.cipher.doFinal(buffer));
    }

    private byte[] concat(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }
}

