/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.internal;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.trilead.ssh2.crypto.PEMDecoder;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.Secret;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.credentials.OpenstackKeystoneV3;
import jenkins.plugins.jclouds.internal.CryptoHelper;
import org.jclouds.ContextBuilder;
import org.springframework.security.core.Authentication;

public final class CredentialsHelper {
    static final Logger LOGGER = Logger.getLogger(CredentialsHelper.class.getName());

    public static String storeCredentials(StandardUsernameCredentials u) throws IOException {
        if (null != u) {
            try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
                CredentialsStore s = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Jenkins.get()).iterator().next();
                s.addCredentials(Domain.global(), (Credentials)u);
                String string = u.getId();
                return string;
            }
        }
        return null;
    }

    public static boolean isRSACredential(String id) {
        try {
            new CryptoHelper(id);
        }
        catch (IllegalStateException x) {
            return false;
        }
        return true;
    }

    public static StandardUsernameCredentials getCredentialsById(String id) {
        if (null == id || id.isEmpty()) {
            return null;
        }
        return SSHLauncher.lookupSystemCredentials((String)id);
    }

    public static String convertCredentials(String description, String identity, Secret credential) {
        try {
            UsernamePasswordCredentialsImpl u = new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, null, description, identity, Secret.toString((Secret)credential));
            return CredentialsHelper.storeCredentials((StandardUsernameCredentials)u);
        }
        catch (Descriptor.FormException | IOException e) {
            LOGGER.warning(String.format("Error while migrating identity/credentials: %s", e.getMessage()));
            return null;
        }
    }

    public static void setProject(String id, Properties overrides) {
        StandardUsernameCredentials u = CredentialsHelper.getCredentialsById(id);
        if (null != u) {
            if (u instanceof OpenstackKeystoneV3) {
                overrides.put("jclouds.keystone.version", "3");
                OpenstackKeystoneV3 ok3 = (OpenstackKeystoneV3)u;
                if (!ok3.getProject().isEmpty()) {
                    overrides.put("jclouds.keystone.scope", "project:" + ok3.getProject());
                }
                return;
            }
            if (u instanceof StandardUsernamePasswordCredentials) {
                return;
            }
            if (u instanceof SSHUserPrivateKey) {
                return;
            }
            throw new RuntimeException("invalid credentials type");
        }
        throw new RuntimeException("Could not retrieve credentials");
    }

    public static ContextBuilder setCredentials(ContextBuilder cb, String id) {
        StandardUsernameCredentials u = CredentialsHelper.getCredentialsById(id);
        if (null != u) {
            if (u instanceof OpenstackKeystoneV3) {
                OpenstackKeystoneV3 ok3 = (OpenstackKeystoneV3)u;
                String domainname = ok3.getDomain().isEmpty() ? "default" : ok3.getDomain();
                return cb.credentials(domainname + ":" + ok3.getUsername(), CredentialsHelper.getPassword(ok3.getPassword()));
            }
            if (u instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials up = (StandardUsernamePasswordCredentials)u;
                return cb.credentials(up.getUsername(), CredentialsHelper.getPassword(up.getPassword()));
            }
            if (u instanceof SSHUserPrivateKey) {
                SSHUserPrivateKey up = (SSHUserPrivateKey)u;
                return cb.credentials(up.getUsername(), CredentialsHelper.getPrivateKey(up));
            }
            throw new RuntimeException("invalid credentials type");
        }
        throw new RuntimeException("Could not retrieve credentials");
    }

    public static String getCredentialsHash(String id) throws NoSuchAlgorithmException {
        StandardUsernameCredentials u = CredentialsHelper.getCredentialsById(id);
        if (null != u) {
            HexFormat hex = HexFormat.of();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            if (u instanceof OpenstackKeystoneV3) {
                OpenstackKeystoneV3 ok3 = (OpenstackKeystoneV3)u;
                md.update(ok3.getDomain().getBytes(StandardCharsets.UTF_8));
                md.update(ok3.getProject().getBytes(StandardCharsets.UTF_8));
                md.update(ok3.getUsername().getBytes(StandardCharsets.UTF_8));
                return hex.formatHex(md.digest(CredentialsHelper.getPasswordOrEmpty(ok3.getPassword()).getBytes(StandardCharsets.UTF_8)));
            }
            if (u instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials up = (StandardUsernamePasswordCredentials)u;
                md.update(up.getUsername().getBytes(StandardCharsets.UTF_8));
                return hex.formatHex(md.digest(CredentialsHelper.getPasswordOrEmpty(up.getPassword()).getBytes(StandardCharsets.UTF_8)));
            }
            if (u instanceof SSHUserPrivateKey) {
                SSHUserPrivateKey up = (SSHUserPrivateKey)u;
                md.update(CredentialsHelper.getPasswordOrEmpty(up.getPassphrase()).getBytes(StandardCharsets.UTF_8));
                md.update(up.getUsername().getBytes(StandardCharsets.UTF_8));
                return hex.formatHex(md.digest(String.join((CharSequence)"", up.getPrivateKeys()).getBytes(StandardCharsets.UTF_8)));
            }
            throw new RuntimeException("invalid credentials type");
        }
        throw new RuntimeException("Could not retrieve credentials with id " + id);
    }

    public static String getPrivateKey(SSHUserPrivateKey supk) {
        if (null == supk) {
            return "";
        }
        List privateKeys = supk.getPrivateKeys();
        return privateKeys.isEmpty() ? "" : (String)privateKeys.get(0);
    }

    public static String getPassword(Secret s) {
        return null == s ? null : s.getPlainText();
    }

    private static String getPasswordOrEmpty(Secret s) {
        return null == s ? "" : s.getPlainText();
    }

    public static KeyPair getKeyPairFromCredential(String id) throws IOException {
        if (null != id && !id.isEmpty()) {
            SSHUserPrivateKey supk = (SSHUserPrivateKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(SSHUserPrivateKey.class, null, null), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
            if (null == supk) {
                throw new IOException("Credential " + id + " is not available");
            }
            String pem = CredentialsHelper.getPrivateKey(supk);
            String passPhrase = CredentialsHelper.getPassword(supk.getPassphrase());
            return PEMDecoder.decodeKeyPair((char[])pem.toCharArray(), (String)passPhrase);
        }
        return null;
    }
}

