/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.credentials;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import hudson.Extension;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.commons.fileupload2.core.FileItem;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class JCloudsUserWithKey
extends BasicSSHUserPrivateKey {
    private static final Logger LOGGER = Logger.getLogger(JCloudsUserWithKey.class.getName());

    @DataBoundConstructor
    public JCloudsUserWithKey(CredentialsScope scope, String id, String description, String username, String privateKey, String jsonFile) {
        super(scope, id, JCloudsUserWithKey.handleUser(jsonFile, username), (BasicSSHUserPrivateKey.PrivateKeySource)JCloudsUserWithKey.handleKey(jsonFile, privateKey), null, JCloudsUserWithKey.handleDescription(jsonFile, description));
    }

    private static String getJsonString(String fileUploadEntry, String fieldName) {
        if (null != fileUploadEntry) {
            try {
                String content;
                FileItem fi = Stapler.getCurrentRequest2().getFileItem2(fileUploadEntry);
                if (null != fi && null != (content = new String(fi.get(), StandardCharsets.UTF_8)) && !content.isEmpty()) {
                    JsonObject jo = JsonParser.parseString((String)content).getAsJsonObject();
                    String value = jo.get(fieldName).getAsString();
                    return value;
                }
            }
            catch (Exception x) {
                LOGGER.warning(x.getMessage());
            }
        }
        return null;
    }

    private static BasicSSHUserPrivateKey.DirectEntryPrivateKeySource handleKey(String json, String key) {
        String value = JCloudsUserWithKey.getJsonString(json, "private_key");
        if (null == value) {
            return new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(key);
        }
        return new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(value);
    }

    private static String handleUser(String json, String user) {
        String value = JCloudsUserWithKey.getJsonString(json, "client_email");
        if (null == value) {
            if (null == user || user.isEmpty()) {
                return "unknown";
            }
            return user;
        }
        return value;
    }

    private static String handleDescription(String json, String description) {
        String value = JCloudsUserWithKey.getJsonString(json, "project_id");
        if (null == value) {
            return description;
        }
        return String.format("Imported JSON key for %s", value);
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "JClouds Username with key";
        }
    }
}

