/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import hudson.Extension;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.AbstractJCloudsConfigProviderImpl;
import jenkins.plugins.jclouds.config.CloudInitContentType;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataYaml
extends Config {
    @DataBoundConstructor
    public UserDataYaml(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public UserDataYaml dup() {
        UserDataYaml ret = new UserDataYaml(UUID.randomUUID().toString(), this.name, this.comment, this.content);
        String pid = this.getProviderId();
        if (null != pid) {
            ret.setProviderId(pid);
        }
        return ret;
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(UserDataYamlProvider.class);
    }

    @Extension(ordinal=70.0)
    @ConfigSuitableFor(target=UserData.class)
    public static class UserDataYamlProvider
    extends AbstractJCloudsConfigProviderImpl {
        private static final String SIGNATURE = "^#cloud-config[\\r\\n]+";
        private static final String DEFAULT_CONTENT = "#cloud-config\n";
        private static final String DEFAULT_NAME = "jclouds.yaml";

        public UserDataYamlProvider() {
            this.load();
        }

        @Override
        public String getSignature() {
            return SIGNATURE;
        }

        public ContentType getContentType() {
            return CloudInitContentType.CLOUDCONFIG;
        }

        public String getDisplayName() {
            return "JClouds user data (yaml)";
        }

        public Config newConfig(String id) {
            return new UserDataYaml(id, DEFAULT_NAME, "", DEFAULT_CONTENT);
        }

        public UserDataYaml convert(Config config) {
            return new UserDataYaml(config.id, config.name, config.comment, config.content);
        }
    }
}

