/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import hudson.Extension;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.AbstractJCloudsConfigProviderImpl;
import jenkins.plugins.jclouds.config.CloudInitContentType;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataUpstart
extends Config {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public UserDataUpstart(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public UserDataUpstart dup() {
        UserDataUpstart ret = new UserDataUpstart(UUID.randomUUID().toString(), this.name, this.comment, this.content);
        String pid = this.getProviderId();
        if (null != pid) {
            ret.setProviderId(pid);
        }
        return ret;
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(UserDataUpstartProvider.class);
    }

    @Extension(ordinal=70.0)
    @ConfigSuitableFor(target=UserData.class)
    public static class UserDataUpstartProvider
    extends AbstractJCloudsConfigProviderImpl {
        private static final String SIGNATURE = "^#upstart-job[\\r\\n]+";
        private static final String DEFAULT_CONTENT = "#upstart-job\n";
        private static final String DEFAULT_NAME = "jclouds.upstart";

        public UserDataUpstartProvider() {
            this.load();
        }

        @Override
        public String getSignature() {
            return SIGNATURE;
        }

        public ContentType getContentType() {
            return CloudInitContentType.UPSTART;
        }

        public String getDisplayName() {
            return "JClouds user data (upstart)";
        }

        public UserDataUpstart newConfig(String id) {
            return new UserDataUpstart(id, DEFAULT_NAME, "", DEFAULT_CONTENT);
        }

        public UserDataUpstart convert(Config config) {
            return new UserDataUpstart(config.id, config.name, config.comment, config.content);
        }
    }
}

