/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import hudson.Extension;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.AbstractJCloudsConfigProviderImpl;
import jenkins.plugins.jclouds.config.CloudInitContentType;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataScript
extends Config {
    @DataBoundConstructor
    public UserDataScript(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public UserDataScript dup() {
        UserDataScript ret = new UserDataScript(UUID.randomUUID().toString(), this.name, this.comment, this.content);
        String pid = this.getProviderId();
        if (null != pid) {
            ret.setProviderId(pid);
        }
        return ret;
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(UserDataScriptProvider.class);
    }

    @Extension(ordinal=70.0)
    @ConfigSuitableFor(target=UserData.class)
    public static class UserDataScriptProvider
    extends AbstractJCloudsConfigProviderImpl {
        private static final String SIGNATURE = "^#!";
        private static final String DEFAULT_CONTENT = "#!/bin/sh\n";
        private static final String DEFAULT_NAME = "jclouds.sh";

        public UserDataScriptProvider() {
            this.load();
        }

        @Override
        public String getSignature() {
            return SIGNATURE;
        }

        public ContentType getContentType() {
            return CloudInitContentType.SHELL;
        }

        public String getDisplayName() {
            return "JClouds user data (shell script)";
        }

        public UserDataScript newConfig(String id) {
            return new UserDataScript(id, DEFAULT_NAME, "", DEFAULT_CONTENT);
        }

        public UserDataScript convert(Config config) {
            return new UserDataScript(config.id, config.name, config.comment, config.content);
        }
    }
}

