/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import hudson.Extension;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.AbstractJCloudsConfigProviderImpl;
import jenkins.plugins.jclouds.config.CloudInitContentType;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataPartHandler
extends Config {
    @DataBoundConstructor
    public UserDataPartHandler(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public UserDataPartHandler dup() {
        UserDataPartHandler ret = new UserDataPartHandler(UUID.randomUUID().toString(), this.name, this.comment, this.content);
        String pid = this.getProviderId();
        if (null != pid) {
            ret.setProviderId(pid);
        }
        return ret;
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(UserDataPartHandlerProvider.class);
    }

    @Extension(ordinal=70.0)
    @ConfigSuitableFor(target=UserData.class)
    public static class UserDataPartHandlerProvider
    extends AbstractJCloudsConfigProviderImpl {
        private static final String SIGNATURE = "^#part-handler[\\r\\n]+";
        private static final String DEFAULT_CONTENT = "#part-handler\ndef list_types():\n   # return a list of mime-types that are handled by this module\n   return([\"text/go-cubs-go\"])\n\ndef handle_part(data,ctype,filename,payload):\n   # data: the cloudinit object\n   # ctype: '__begin__', '__end__', or the specific mime-type of the part\n   # filename: the filename for the part, or dynamically generated part if\n   #           no filename is given attribute is present\n   # payload: the content of the part (empty for begin or end)\n   if ctype == \"__begin__\":\n       print \"my handler is beginning\"\n       return\n   if ctype == \"__end__\":\n       print \"my handler is ending\"\n       return\n\n   print \"==== received ctype=%s filename=%s ====\" % (ctype,filename)\n   print payload\n   print \"==== end ctype=%s filename=%s\" % (ctype, filename)\n";
        private static final String DEFAULT_NAME = "jclouds.parthandler";

        public UserDataPartHandlerProvider() {
            this.load();
        }

        @Override
        public String getSignature() {
            return SIGNATURE;
        }

        public ContentType getContentType() {
            return CloudInitContentType.PARTHANDLER;
        }

        public String getDisplayName() {
            return "JClouds user data (part-handler)";
        }

        public UserDataPartHandler newConfig(String id) {
            return new UserDataPartHandler(id, DEFAULT_NAME, "", DEFAULT_CONTENT);
        }

        public UserDataPartHandler convert(Config config) {
            return new UserDataPartHandler(config.id, config.name, config.comment, config.content);
        }
    }
}

