/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import hudson.Extension;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.AbstractJCloudsConfigProviderImpl;
import jenkins.plugins.jclouds.config.CloudInitContentType;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataIncludeOnce
extends Config {
    @DataBoundConstructor
    public UserDataIncludeOnce(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public UserDataIncludeOnce dup() {
        UserDataIncludeOnce ret = new UserDataIncludeOnce(UUID.randomUUID().toString(), this.name, this.comment, this.content);
        String pid = this.getProviderId();
        if (null != pid) {
            ret.setProviderId(pid);
        }
        return ret;
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(UserDataIncludeOnceProvider.class);
    }

    @Extension(ordinal=70.0)
    @ConfigSuitableFor(target=UserData.class)
    public static class UserDataIncludeOnceProvider
    extends AbstractJCloudsConfigProviderImpl {
        private static final String SIGNATURE = "^#include-once[\\r\\n]+";
        private static final String DEFAULT_CONTENT = "#include-once\n";
        private static final String DEFAULT_NAME = "jclouds.include-once";

        public UserDataIncludeOnceProvider() {
            this.load();
        }

        @Override
        public String getSignature() {
            return SIGNATURE;
        }

        public ContentType getContentType() {
            return null;
        }

        @Override
        public ContentType getRealContentType() {
            return CloudInitContentType.INCLUDEONCE;
        }

        public String getDisplayName() {
            return "JClouds user data (include once)";
        }

        public UserDataIncludeOnce newConfig(String id) {
            return new UserDataIncludeOnce(id, DEFAULT_NAME, "", DEFAULT_CONTENT);
        }

        public UserDataIncludeOnce convert(Config config) {
            return new UserDataIncludeOnce(config.id, config.name, config.comment, config.content);
        }
    }
}

