/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import hudson.Extension;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.AbstractJCloudsConfigProviderImpl;
import jenkins.plugins.jclouds.config.CloudInitContentType;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataInclude
extends Config {
    @DataBoundConstructor
    public UserDataInclude(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public UserDataInclude dup() {
        UserDataInclude ret = new UserDataInclude(UUID.randomUUID().toString(), this.name, this.comment, this.content);
        String pid = this.getProviderId();
        if (null != pid) {
            ret.setProviderId(pid);
        }
        return ret;
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(UserDataIncludeProvider.class);
    }

    @Extension(ordinal=70.0)
    @ConfigSuitableFor(target=UserData.class)
    public static class UserDataIncludeProvider
    extends AbstractJCloudsConfigProviderImpl {
        private static final String SIGNATURE = "^#include[\\r\\n]+";
        private static final String DEFAULT_CONTENT = "#include\n";
        private static final String DEFAULT_NAME = "jclouds.include";

        public UserDataIncludeProvider() {
            this.load();
        }

        @Override
        public String getSignature() {
            return SIGNATURE;
        }

        public ContentType getContentType() {
            return null;
        }

        @Override
        public ContentType getRealContentType() {
            return CloudInitContentType.INCLUDE;
        }

        public String getDisplayName() {
            return "JClouds user data (include)";
        }

        public UserDataInclude newConfig(String id) {
            return new UserDataInclude(id, DEFAULT_NAME, "", DEFAULT_CONTENT);
        }

        public UserDataInclude convert(Config config) {
            return new UserDataInclude(config.id, config.name, config.comment, config.content);
        }
    }
}

