/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import hudson.Extension;
import java.util.UUID;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.AbstractJCloudsConfigProviderImpl;
import jenkins.plugins.jclouds.config.CloudInitContentType;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.kohsuke.stapler.DataBoundConstructor;

public class UserDataBoothook
extends Config {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public UserDataBoothook(String id, String name, String comment, String content) {
        super(id, name, comment, content);
    }

    public UserDataBoothook dup() {
        UserDataBoothook ret = new UserDataBoothook(UUID.randomUUID().toString(), this.name, this.comment, this.content);
        String pid = this.getProviderId();
        if (null != pid) {
            ret.setProviderId(pid);
        }
        return ret;
    }

    public ConfigProvider getDescriptor() {
        return (ConfigProvider)Jenkins.get().getDescriptorByType(UserDataBoothookProvider.class);
    }

    @Extension(ordinal=70.0)
    @ConfigSuitableFor(target=UserData.class)
    public static class UserDataBoothookProvider
    extends AbstractJCloudsConfigProviderImpl {
        private static final String SIGNATURE = "^#cloud-boothook[\\r\\n]+";
        private static final String DEFAULT_CONTENT = "#cloud-boothook\n";
        private static final String DEFAULT_NAME = "jclouds.boothook";

        public UserDataBoothookProvider() {
            this.load();
        }

        @Override
        public String getSignature() {
            return SIGNATURE;
        }

        public ContentType getContentType() {
            return CloudInitContentType.BOOTHOOK;
        }

        public String getDisplayName() {
            return "JClouds user data (boot hook)";
        }

        public UserDataBoothook newConfig(String id) {
            return new UserDataBoothook(id, DEFAULT_NAME, "", DEFAULT_CONTENT);
        }

        public UserDataBoothook convert(Config config) {
            return new UserDataBoothook(config.id, config.name, config.comment, config.content);
        }
    }
}

