/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.ItemGroup;
import hudson.util.ListBoxModel;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.ConfigDataSource;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import jenkins.plugins.jclouds.config.JCloudsConfig;
import jenkins.plugins.jclouds.config.UserDataScript;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.ConfigFiles;

public class ConfigHelper {
    private static final Logger LOGGER = Logger.getLogger(ConfigHelper.class.getName());

    private ConfigHelper() {
    }

    @NonNull
    public static String getConfig(@Nullable String id) {
        Config cfg;
        if (id != null && null != (cfg = ConfigFiles.getByIdOrNull((ItemGroup)Jenkins.get(), (String)id)) && null != cfg.content) {
            return cfg.content;
        }
        return "";
    }

    public static ContentType getRealContentType(@NonNull ConfigProvider p) {
        ContentType ct = p.getContentType();
        if (null == ct && p instanceof JCloudsConfig) {
            ct = ((JCloudsConfig)p).getRealContentType();
        }
        return ct;
    }

    @CheckForNull
    private static BodyPart buildBody(Config cfg, @Nullable Map<String, String> replacements) {
        ConfigDataSource source = new ConfigDataSource(cfg, true, replacements);
        if (null != source) {
            try {
                MimeBodyPart body = new MimeBodyPart();
                String mime = source.getContentType();
                body.setDataHandler(new DataHandler((DataSource)source));
                body.setHeader("Content-Type", mime + "; charset=\"utf8\"");
                if (mime.equals("text/cloud-config")) {
                    body.setHeader("Merge-Type", "dict(allow_delete,recurse_array)+list(recurse_array,append)");
                }
                body.setFileName(source.getName());
                return body;
            }
            catch (MessagingException e) {
                LOGGER.log(Level.WARNING, "", e);
            }
        }
        return null;
    }

    @NonNull
    private static List<Config> getConfigs(@NonNull List<String> configIds) {
        ArrayList<Config> ret = new ArrayList<Config>();
        for (String id : configIds) {
            Config cfg = ConfigFiles.getByIdOrNull((ItemGroup)Jenkins.get(), (String)id);
            if (null == cfg) continue;
            ret.add(cfg);
        }
        return ret;
    }

    private static byte[] injectMimeVersion(@NonNull byte[] msg) {
        String[] lines = new String(msg, StandardCharsets.UTF_8).split("\n");
        if (3 < lines.length && lines[0].contains("multipart")) {
            String[] ret = new String[lines.length + 1];
            System.arraycopy(lines, 0, ret, 0, 2);
            System.arraycopy(lines, 2, ret, 3, lines.length - 2);
            ret[2] = "MIME-Version: 1.0";
            return Joiner.on((String)"\n").join(Arrays.asList(ret)).getBytes(StandardCharsets.UTF_8);
        }
        return msg;
    }

    @CheckForNull
    public static byte[] buildUserData(@NonNull List<String> configIds, @Nullable Map<String, String> replacements, boolean gzip) throws IOException {
        List<Config> configs = ConfigHelper.getConfigs(configIds);
        if (configs.isEmpty()) {
            return null;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            block23: {
                try (OutputStream os = gzip ? new GZIPOutputStream(baos) : baos;){
                    if (configs.size() > 1) {
                        try {
                            MimeMessage msg = new MimeMessage((Session)null);
                            MimeMultipart multipart = new MimeMultipart();
                            for (Config cfg : configs) {
                                BodyPart body = ConfigHelper.buildBody(cfg, replacements);
                                if (null == body) continue;
                                multipart.addBodyPart(body);
                            }
                            msg.setContent((Multipart)multipart);
                            try (ByteArrayOutputStream tmpbaos = new ByteArrayOutputStream();){
                                msg.writeTo((OutputStream)tmpbaos, new String[]{"Date", "Message-ID", "MIME-Version"});
                                os.write(ConfigHelper.injectMimeVersion(tmpbaos.toByteArray()));
                                break block23;
                            }
                        }
                        catch (MessagingException | IOException e) {
                            LOGGER.log(Level.WARNING, "", e);
                        }
                        break block23;
                    }
                    Config cfg = configs.get(0);
                    if (null != cfg.content && !cfg.content.isEmpty()) {
                        os.write(cfg.content.getBytes(StandardCharsets.UTF_8));
                        break block23;
                    }
                    byte[] byArray = null;
                    return byArray;
                }
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static void appendItemsOfProvider(@NonNull ConfigProvider p, @NonNull ListBoxModel m, @Nullable String currentValue) {
        StringBuffer sb = new StringBuffer();
        ConfigSuitableFor a = p.getClass().getAnnotation(ConfigSuitableFor.class);
        if (null != a && a.target() == UserData.class) {
            for (Config cfg : ConfigFiles.getConfigsInContext((ItemGroup)Jenkins.get(), p.getClass())) {
                sb.setLength(0);
                sb.append(p.getDisplayName()).append(" ").append(cfg.name);
                if (cfg.comment != null && !cfg.comment.isEmpty()) {
                    sb.append(" [").append(cfg.comment).append("]");
                }
                m.add(sb.toString(), cfg.id);
                if (!cfg.id.equals(currentValue)) continue;
                ((ListBoxModel.Option)m.get((int)(m.size() - 1))).selected = true;
            }
        }
    }

    @NonNull
    public static ListBoxModel doFillFileItems(@Nullable String currentValue) {
        ListBoxModel m = new ListBoxModel();
        m.add("- none -", "");
        for (ConfigProvider p : ConfigProvider.all()) {
            ConfigHelper.appendItemsOfProvider(p, m, currentValue);
        }
        return m;
    }

    @NonNull
    public static ListBoxModel doFillInitScriptItems(@Nullable String currentValue) {
        ListBoxModel m = new ListBoxModel();
        m.add("- none -", "");
        ConfigHelper.appendItemsOfProvider(new UserDataScript("-", "", "", "").getProvider(), m, currentValue);
        return m;
    }

    public static Map<String, String> getUserDataHashes(List<String> configIds) throws NoSuchAlgorithmException {
        return ConfigHelper.getUserDataHashesFromConfigs(ConfigHelper.getConfigs(configIds));
    }

    public static Map<String, String> getUserDataHashesFromConfigs(List<Config> cfgs) throws NoSuchAlgorithmException {
        HexFormat hex = HexFormat.of();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Config cfg : cfgs) {
            ConfigDataSource ds = new ConfigDataSource(cfg, false, Map.of());
            String content = null == cfg.content ? "" : cfg.content;
            md.update(ds.getContentType().getBytes(StandardCharsets.UTF_8));
            md.update(cfg.name.getBytes(StandardCharsets.UTF_8));
            md.update(cfg.comment.getBytes(StandardCharsets.UTF_8));
            String hash = hex.formatHex(md.digest(content.getBytes(StandardCharsets.UTF_8)));
            ret.put(cfg.id, hash);
        }
        return ret;
    }

    public static List<Config> getJCloudsConfigs() {
        ArrayList<Config> cfgs = new ArrayList<Config>();
        for (ConfigProvider p : ConfigProvider.all()) {
            ConfigSuitableFor a = p.getClass().getAnnotation(ConfigSuitableFor.class);
            if (null == a || a.target() != UserData.class) continue;
            for (Config cfg : ConfigFiles.getConfigsInContext((ItemGroup)Jenkins.get(), p.getClass())) {
                cfgs.add(cfg);
            }
        }
        return cfgs;
    }

    public static String exportXml() {
        return Jenkins.XSTREAM.toXML(ConfigHelper.getJCloudsConfigs());
    }
}

