/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.ItemGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.config.ConfigSuitableFor;
import jenkins.plugins.jclouds.internal.CryptoHelper;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;

public class ConfigExport {
    private static final Logger LOGGER = Logger.getLogger(ConfigExport.class.getName());
    public final String credentialsId;
    public List<Config> configData;
    protected String encryptedConfigData;
    private final transient List<Config> tmp;

    public ConfigExport(@CheckForNull String id) {
        this.credentialsId = id;
        this.tmp = new ArrayList<Config>();
        for (ConfigProvider p : ConfigProvider.all()) {
            ConfigSuitableFor a = p.getClass().getAnnotation(ConfigSuitableFor.class);
            if (null == a || a.target() != UserData.class) continue;
            for (Config cfg : ConfigFiles.getConfigsInContext((ItemGroup)Jenkins.get(), p.getClass())) {
                this.tmp.add(cfg);
            }
        }
        if (null != this.credentialsId && !this.credentialsId.isEmpty()) {
            this.configData = null;
            this.encryptedConfigData = null;
        } else {
            LOGGER.warning("Unencrypted export");
            this.configData = this.tmp;
            this.encryptedConfigData = null;
        }
    }

    public String getEncryptedConfigData() {
        return this.encryptedConfigData;
    }

    @NonNull
    public String exportXml() {
        if (null != this.credentialsId && !this.credentialsId.isEmpty()) {
            CryptoHelper ch = new CryptoHelper(this.credentialsId);
            this.encryptedConfigData = ch.encrypt(Jenkins.XSTREAM.toXML(this.tmp));
        }
        return Jenkins.XSTREAM.toXML((Object)this);
    }
}

