/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import jakarta.activation.DataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Pattern;
import jenkins.plugins.jclouds.config.ConfigHelper;
import jenkins.plugins.jclouds.config.JCloudsConfig;
import jenkins.plugins.jclouds.config.UserDataScript;
import jenkins.plugins.jclouds.internal.ReplaceHelper;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;

public class ConfigDataSource
implements DataSource {
    private final Config cfg;
    private final boolean stripSignature;
    private final Map<String, String> replaceMap;

    public ConfigDataSource(@NonNull Config config, boolean strip, @Nullable Map<String, String> replacements) {
        this.cfg = config;
        this.stripSignature = strip;
        this.replaceMap = replacements;
    }

    public InputStream getInputStream() throws IOException {
        ConfigProvider p;
        String content;
        String string = content = null == this.cfg.content ? "" : this.cfg.content;
        if (this.stripSignature && (p = this.cfg.getProvider()) instanceof JCloudsConfig && !(p instanceof UserDataScript.UserDataScriptProvider)) {
            String sig = ((JCloudsConfig)p).getSignature();
            content = Pattern.compile(sig, 32).matcher(content).replaceFirst("");
        }
        content = new ReplaceHelper(this.replaceMap).replace(content);
        return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("ConfigDatasource is readonly");
    }

    public String getContentType() {
        ContentType ct = ConfigHelper.getRealContentType(this.cfg.getProvider());
        String mime = null == ct ? null : ct.getMime();
        return null == mime ? "application/octet-stream" : mime;
    }

    public String getName() {
        return null == this.cfg.name ? "" : this.cfg.name;
    }
}

