/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import hudson.XmlFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.internal.RunningNode;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;

public class TerminateNodes
implements Function<Iterable<RunningNode>, Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(TerminateNodes.class.getName());

    private static ComputeService getCloudCompute(String cloud) {
        return ((JCloudsCloud)Jenkins.get().clouds.getByName(cloud)).getCompute();
    }

    public Void apply(Iterable<RunningNode> runningNodes) {
        if (null != runningNodes) {
            ImmutableMultimap.Builder cloudNodesToSuspendBuilder = ImmutableMultimap.builder();
            ImmutableMultimap.Builder cloudNodesToDestroyBuilder = ImmutableMultimap.builder();
            for (RunningNode node : runningNodes) {
                String id = node.getNodeId();
                String name = node.getCloudName();
                if (node.getShouldSuspend()) {
                    cloudNodesToSuspendBuilder.put((Object)name, (Object)id);
                    continue;
                }
                cloudNodesToDestroyBuilder.put((Object)name, (Object)id);
            }
            ImmutableMultimap toSuspend = cloudNodesToSuspendBuilder.build();
            ImmutableMultimap toDestroy = cloudNodesToDestroyBuilder.build();
            Persistent p = new Persistent(this.toString(), (Multimap<String, String>)toSuspend, (Multimap<String, String>)toDestroy);
            this.suspendIfSupported((Multimap<String, String>)toSuspend);
            this.destroy((Multimap<String, String>)toDestroy);
            p.remove();
        }
        return null;
    }

    private void destroy(Multimap<String, String> cloudNodesToDestroy) {
        for (String cloudToDestroy : cloudNodesToDestroy.keySet()) {
            final Collection nodesToDestroy = cloudNodesToDestroy.get((Object)cloudToDestroy);
            LOGGER.info("Destroying supplemental nodes: " + String.valueOf(nodesToDestroy));
            TerminateNodes.getCloudCompute(cloudToDestroy).destroyNodesMatching((Predicate)new Predicate<NodeMetadata>(){

                public boolean apply(NodeMetadata input) {
                    return null != input && nodesToDestroy.contains(input.getId());
                }
            });
        }
    }

    private void suspendIfSupported(Multimap<String, String> cloudNodesToSuspend) {
        for (String cloudToSuspend : cloudNodesToSuspend.keySet()) {
            final Collection nodesToSuspend = cloudNodesToSuspend.get((Object)cloudToSuspend);
            try {
                LOGGER.info("Suspending supplemental nodes: " + String.valueOf(nodesToSuspend));
                TerminateNodes.getCloudCompute(cloudToSuspend).suspendNodesMatching((Predicate)new Predicate<NodeMetadata>(){

                    public boolean apply(NodeMetadata input) {
                        return null != input && nodesToSuspend.contains(input.getId());
                    }
                });
            }
            catch (UnsupportedOperationException e) {
                LOGGER.warning("Suspend unsupported on cloud: " + cloudToSuspend + "; affected nodes: " + String.valueOf(nodesToSuspend) + ": " + String.valueOf(e));
            }
        }
    }

    public static class Persistent {
        private static final Logger LOGGER = Logger.getLogger(Persistent.class.getName());
        private final transient File f;
        private Multimap<String, String> nodesToSuspend;
        private Multimap<String, String> nodesToDestroy;

        public Persistent(String name, Multimap<String, String> toSuspend, Multimap<String, String> toDestroy) {
            this.nodesToSuspend = toSuspend;
            this.nodesToDestroy = toDestroy;
            this.f = new File(Jenkins.get().getRootDir(), name + ".xml");
            XmlFile xf = new XmlFile(this.f);
            try {
                xf.write((Object)this);
            }
            catch (IOException x) {
                LOGGER.warning(String.format("Failed to persist %s: %s", this.f.getAbsolutePath(), x.getMessage()));
            }
        }

        public Persistent(File src) {
            this.f = src;
            XmlFile xf = new XmlFile(this.f);
            try {
                xf.unmarshal((Object)this);
            }
            catch (IOException x) {
                this.nodesToSuspend = ArrayListMultimap.create();
                this.nodesToDestroy = ArrayListMultimap.create();
                LOGGER.warning(String.format("Failed to unmarshal %s: %s", this.f.getAbsolutePath(), x.getMessage()));
            }
        }

        public void remove() {
            if (!this.f.delete()) {
                LOGGER.warning("Could not delete " + this.f.getAbsolutePath());
            }
        }

        public Multimap<String, String> getNodesToSuspend() {
            return this.nodesToSuspend;
        }

        public Multimap<String, String> getNodesToDestroy() {
            return this.nodesToDestroy;
        }
    }
}

