/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsLauncher;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import jenkins.plugins.jclouds.compute.internal.JCloudsNodeMetadata;
import org.jclouds.compute.domain.NodeMetadata;

public class RunningNode
implements Serializable {
    static final Logger LOGGER = Logger.getLogger(RunningNode.class.getName());
    private static final long serialVersionUID = 1L;
    private final String cloud;
    private final String template;
    private final boolean shouldSuspend;
    private String nodeId = null;
    private String nodeName = null;
    private String hostName = null;
    private String nodeInstanceAddress = null;
    private transient JCloudsNodeMetadata node;

    public RunningNode(String cloud, String template, boolean shouldSuspend, JCloudsNodeMetadata node) {
        this.cloud = cloud;
        this.template = template;
        this.shouldSuspend = shouldSuspend;
        this.node = node;
        this.copyMetadata(null);
    }

    private void copyMetadata(PrintStream logger) {
        if (null != this.node) {
            this.nodeId = this.node.getId();
            this.nodeName = this.node.getName();
            this.hostName = this.node.getHostname();
            String preferredAddress = null;
            JCloudsCloud c = (JCloudsCloud)Jenkins.get().clouds.getByName(this.cloud);
            if (null != c) {
                for (JCloudsSlaveTemplate t : c.getTemplates()) {
                    if (!t.name.equals(this.template)) continue;
                    preferredAddress = t.getPreferredAddress();
                    break;
                }
            }
            if (null != c) {
                NodeMetadata md = c.getCompute().getNodeMetadata(this.nodeId);
                this.nodeInstanceAddress = JCloudsLauncher.getConnectionAddress(md, logger, preferredAddress);
            } else {
                LOGGER.severe(String.format(this.cloud, new Object[0]));
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.copyMetadata(null);
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.node = null;
    }

    public String getNodeId() {
        this.copyMetadata(null);
        return this.nodeId;
    }

    public String getNodeName() {
        this.copyMetadata(null);
        return this.nodeName;
    }

    public String getHostName() {
        this.copyMetadata(null);
        return this.hostName;
    }

    public String getNodeInstanceAddress(PrintStream logger) {
        this.copyMetadata(logger);
        return this.nodeInstanceAddress;
    }

    public String getCloudName() {
        return this.cloud;
    }

    public String getTemplateName() {
        return this.template;
    }

    public boolean getShouldSuspend() {
        return this.shouldSuspend;
    }
}

