/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute.internal;

import com.google.common.base.Supplier;
import java.util.concurrent.Callable;
import jenkins.plugins.jclouds.compute.internal.JCloudsNodeMetadata;
import org.jclouds.logging.Logger;

class RetryOnExceptionSupplier
implements Callable<JCloudsNodeMetadata> {
    private static final int MAX_ATTEMPTS = 5;
    private final Logger logger;
    private final Supplier<JCloudsNodeMetadata> supplier;

    RetryOnExceptionSupplier(Supplier<JCloudsNodeMetadata> supplier, Logger logger) {
        this.supplier = supplier;
        this.logger = logger;
    }

    @Override
    public JCloudsNodeMetadata call() throws Exception {
        for (int attempts = 0; attempts < 5; ++attempts) {
            try {
                JCloudsNodeMetadata n = (JCloudsNodeMetadata)((Object)this.supplier.get());
                if (n == null) continue;
                return n;
            }
            catch (RuntimeException e) {
                this.logger.warn("Exception creating a node: " + e.getMessage(), new Object[0]);
                continue;
            }
        }
        return null;
    }
}

