/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.jclouds.compute.internal.JCloudsNodeMetadata;
import jenkins.plugins.jclouds.compute.internal.NodePlan;
import jenkins.plugins.jclouds.compute.internal.RetryOnExceptionSupplier;
import jenkins.plugins.jclouds.compute.internal.RunningNode;

public class ProvisionPlannedInstancesAndDestroyAllOnError
implements Function<Iterable<NodePlan>, Iterable<RunningNode>> {
    static final Logger LOGGER = Logger.getLogger(ProvisionPlannedInstancesAndDestroyAllOnError.class.getName());
    private final ListeningExecutorService executor;
    private final org.jclouds.logging.Logger logger;
    private final Function<Iterable<RunningNode>, Void> terminateNodes;

    public ProvisionPlannedInstancesAndDestroyAllOnError(ListeningExecutorService executor, org.jclouds.logging.Logger logger, Function<Iterable<RunningNode>, Void> terminateNodes) {
        this.executor = executor;
        this.logger = logger;
        this.terminateNodes = terminateNodes;
    }

    public Iterable<RunningNode> apply(Iterable<NodePlan> nodePlans) {
        final ImmutableList.Builder nodeBuilder = ImmutableList.builder();
        if (null != nodePlans) {
            final AtomicInteger failedCount = new AtomicInteger();
            final AtomicInteger successCount = new AtomicInteger();
            AtomicInteger totalCount = new AtomicInteger();
            for (final NodePlan nodePlan : nodePlans) {
                if (nodePlan.getCount() <= 0) continue;
                totalCount.addAndGet(nodePlan.getCount());
                final String plural = nodePlan.getCount() > 1 ? "s" : "";
                LOGGER.info(String.format("Launching %d supplemental node%s from template %s in cloud %s", nodePlan.getCount(), plural, nodePlan.getTemplateName(), nodePlan.getCloudName()));
                this.logger.info("Launching %d supplemental node%s from template %s in cloud %s", new Object[]{nodePlan.getCount(), plural, nodePlan.getTemplateName(), nodePlan.getCloudName()});
                int i = 0;
                while (i < nodePlan.getCount()) {
                    final int index = i++;
                    ListenableFuture provisionTemplate = this.executor.submit((Callable)new RetryOnExceptionSupplier(nodePlan.getNodeSupplier(), this.logger));
                    Futures.addCallback((ListenableFuture)provisionTemplate, (FutureCallback)new FutureCallback<JCloudsNodeMetadata>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void onSuccess(JCloudsNodeMetadata result) {
                            if (result != null) {
                                ImmutableList.Builder builder = nodeBuilder;
                                synchronized (builder) {
                                    RunningNode rn = new RunningNode(nodePlan.getCloudName(), nodePlan.getTemplateName(), nodePlan.getShouldSuspend(), result);
                                    nodeBuilder.add((Object)rn);
                                    successCount.incrementAndGet();
                                }
                            } else {
                                failedCount.incrementAndGet();
                            }
                        }

                        public void onFailure(Throwable t) {
                            failedCount.incrementAndGet();
                            LOGGER.log(Level.WARNING, String.format("Error launching supplemental node #%d of %d from template %s in cloud %s", index, nodePlan.getCount(), plural, nodePlan.getTemplateName(), nodePlan.getCloudName()), t);
                            ProvisionPlannedInstancesAndDestroyAllOnError.this.logger.warn(t, "Error launching supplemental node #%d of %d from template %s in cloud %s", new Object[]{index, nodePlan.getCount(), plural, nodePlan.getTemplateName(), nodePlan.getCloudName()});
                        }
                    }, (Executor)this.executor);
                }
            }
            if (0 < totalCount.get()) {
                while (successCount.get() + failedCount.get() < totalCount.get()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.warning("Interrupt while waiting for node launch");
                    }
                }
                ImmutableList runningNodes = nodeBuilder.build();
                if (failedCount.get() > 0) {
                    this.terminateNodes.apply((Object)runningNodes);
                    throw new IllegalStateException("One or more nodes failed to launch.");
                }
                LOGGER.info(String.format("launched %d supplemental nodes", successCount.get()));
                this.logger.info("launched %d supplemental nodes", new Object[]{successCount.get()});
                return runningNodes;
            }
        }
        return nodeBuilder.build();
    }
}

