/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ListBoxModel;
import hudson.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.UUID;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.config.ConfigHelper;
import jenkins.plugins.jclouds.config.JCloudsConfig;
import jenkins.plugins.jclouds.config.UserDataScript;
import org.jenkinsci.lib.configprovider.ConfigProvider;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public final class UserData
extends AbstractDescribableImpl<UserData> {
    public final String fileId;

    @DataBoundConstructor
    public UserData(String fileId) {
        this.fileId = fileId;
    }

    @NonNull
    static UserData createFromData(String data, String name) {
        ConfigProvider provider = (ConfigProvider)ConfigProvider.all().get(UserDataScript.UserDataScriptProvider.class);
        for (ConfigProvider p : ConfigProvider.all()) {
            String sig;
            if (!(p instanceof JCloudsConfig) || !Pattern.compile(sig = ((JCloudsConfig)p).getSignature(), 32).matcher(data).find()) continue;
            provider = p;
            break;
        }
        String id = UUID.randomUUID().toString();
        Config c = provider.newConfig(id);
        ReflectionUtils.setField((Field)UserData.getConfigField("name"), (Object)c, (Object)name);
        ReflectionUtils.setField((Field)UserData.getConfigField("comment"), (Object)c, (Object)"auto-migrated");
        ReflectionUtils.setField((Field)UserData.getConfigField("content"), (Object)c, (Object)data);
        GlobalConfigFiles.get().save(c);
        return new UserData(c.id);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static Field getConfigField(String name) {
        Field field = ReflectionUtils.findField(Config.class, (String)name);
        field.setAccessible(true);
        return field;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<UserData> {
        public String getDisplayName() {
            return "";
        }

        @POST
        @NonNull
        public ListBoxModel doFillFileIdItems(@QueryParameter @Nullable String currentValue) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return ConfigHelper.doFillFileItems(currentValue);
        }
    }
}

