/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

final class PhoneHomeMonitor {
    private static final Logger LOGGER = Logger.getLogger(PhoneHomeMonitor.class.getName());
    private final Lock phoneHomeLock = new ReentrantLock();
    private final Condition doneWaitPhoneHome = this.phoneHomeLock.newCondition();
    private boolean isWaiting = false;
    private boolean isInterrupted = false;
    private int waitTimeout = 0;
    private List<String> targets;
    private Thread waitThread = null;

    PhoneHomeMonitor(boolean activate, int timeout) {
        this.isWaiting = activate;
        this.waitTimeout = timeout;
    }

    void join() throws InterruptedException {
        if (null != this.waitThread) {
            this.waitThread.join();
        }
    }

    synchronized boolean ring(String who) {
        boolean ret = this.targets.remove(who);
        if (this.targets.isEmpty()) {
            this.isWaiting = false;
        }
        this.signalCondition();
        return ret;
    }

    void ring() {
        this.isWaiting = false;
        this.signalCondition();
    }

    void interrupt() {
        this.isInterrupted = true;
        this.signalCondition();
    }

    private synchronized String getTargetString() {
        return null == this.targets ? "" : String.join((CharSequence)" and ", this.targets);
    }

    private void signalCondition() {
        this.phoneHomeLock.lock();
        try {
            this.doneWaitPhoneHome.signal();
        }
        finally {
            this.phoneHomeLock.unlock();
        }
    }

    private synchronized void setTargets(List<String> t) {
        this.targets = t;
    }

    private void waitCondition(long millis) throws InterruptedException {
        this.phoneHomeLock.lock();
        try {
            this.doneWaitPhoneHome.await(millis, TimeUnit.MILLISECONDS);
        }
        finally {
            this.phoneHomeLock.unlock();
        }
    }

    private long getWaitPhoneHomeTimeoutMs() {
        if (0 < this.waitTimeout) {
            return 60000L * (long)this.waitTimeout;
        }
        return 0L;
    }

    void waitForPhoneHome(String who, PrintStream logger) throws InterruptedException {
        if (null == who || who.isEmpty()) {
            throw new IllegalArgumentException("who may not me null or empty");
        }
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(who);
        this.setTargets(tmp);
        this.waitForPhoneHome(logger);
    }

    void waitForPhoneHomeMultiple(List<String> who, final PrintStream logger) {
        if (null == who || who.isEmpty()) {
            throw new IllegalArgumentException("who may not be null or empty");
        }
        if (who.contains(null) || who.contains("")) {
            throw new IllegalArgumentException("who may not contain empty targets");
        }
        this.setTargets(who);
        this.waitThread = new Thread(){

            @Override
            public void run() {
                try {
                    PhoneHomeMonitor.this.waitForPhoneHome(logger);
                }
                catch (InterruptedException x) {
                    LOGGER.info(x.toString());
                }
            }
        };
        this.waitThread.start();
    }

    private void waitForPhoneHome(PrintStream logger) throws InterruptedException {
        block6: {
            long timeout = System.currentTimeMillis() + this.getWaitPhoneHomeTimeoutMs();
            boolean hasWaitedAtAll = false;
            while (true) {
                long tdif;
                if ((tdif = timeout - System.currentTimeMillis()) < 0L) {
                    this.ring();
                    throw new InterruptedException("wait for phone home timed out");
                }
                if (this.isInterrupted) {
                    this.ring();
                    throw new InterruptedException("wait for phone home interrupted");
                }
                if (!this.isWaiting) break;
                hasWaitedAtAll = true;
                String tgs = this.getTargetString();
                if (tgs.isEmpty()) continue;
                String msg = "Waiting for " + tgs + " to phone home. " + tdif / 1000L + " seconds until timeout.";
                LOGGER.info(msg);
                if (null != logger) {
                    logger.println(msg);
                }
                if (tdif > 30000L) {
                    tdif = 30000L;
                }
                this.waitCondition(tdif);
            }
            if (!hasWaitedAtAll) break block6;
            String msg = "Finished waiting for phone home";
            LOGGER.info("Finished waiting for phone home");
            if (null != logger) {
                logger.println("Finished waiting for phone home");
            }
        }
    }
}

