/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Metadata;
import org.jclouds.googlecomputeengine.features.InstanceApi;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;

public class MetaDataPublisher {
    private static final Logger LOGGER = Logger.getLogger(MetaDataPublisher.class.getName());
    private final JCloudsCloud c;

    MetaDataPublisher(JCloudsCloud cloud) {
        this.c = cloud;
    }

    private String getLocationPart(NodeMetadata nmd, LocationScope desiredScope) {
        Location loc;
        for (loc = nmd.getLocation(); null != loc && loc.getScope() != desiredScope; loc = loc.getParent()) {
        }
        return null != loc ? loc.getId() : "";
    }

    public void publish(String nodeId, String msg, Map<String, String> data) {
        NodeMetadata nmd = this.c.getCompute().getNodeMetadata(nodeId);
        String providerName = this.c.providerName;
        try {
            if (providerName.equals("openstack-nova")) {
                LOGGER.info(msg);
                String region = this.getLocationPart(nmd, LocationScope.REGION);
                String sid = nmd.getId().replaceFirst("^" + region + "/", "");
                NovaApi napi = this.c.newApi(NovaApi.class);
                ServerApi sapi = napi.getServerApi(region);
                data.putAll(sapi.getMetadata(sid));
                sapi.updateMetadata(sid, data);
                return;
            }
            if (providerName.equals("google-compute-engine")) {
                LOGGER.info(msg);
                String instance = nmd.getName();
                String zone = this.getLocationPart(nmd, LocationScope.ZONE);
                GoogleComputeEngineApi gce = this.c.newApi(GoogleComputeEngineApi.class);
                InstanceApi ia = gce.instancesInZone(zone);
                Metadata md = ia.get(instance).metadata().clone();
                md.putAll(data);
                ia.setMetadata(instance, md);
                return;
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "Failed to set JNLP properties", x);
            return;
        }
        LOGGER.info(String.format(this.c.name, providerName));
    }
}

