/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import hudson.Extension;
import hudson.model.listeners.ItemListener;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.internal.TerminateNodes;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;

@Extension
public class JCloudsStartupHandler
extends ItemListener {
    private static final Logger LOGGER = Logger.getLogger(JCloudsStartupHandler.class.getName());
    private static final String STALE_PATTERN = "jenkins.plugins.jclouds.compute.internal.TerminateNodes@*.xml";
    private final AtomicBoolean initial = new AtomicBoolean(true);

    public void onLoaded() {
        if (this.initial.compareAndSet(true, false)) {
            for (Path path : this.listStaleNodeLists()) {
                TerminateNodes.Persistent p = new TerminateNodes.Persistent(path.toFile());
                try {
                    ComputeService cs;
                    Collection nodes;
                    JCloudsCloud c;
                    Multimap<String, String> work = p.getNodesToSuspend();
                    for (String cloud : work.keySet()) {
                        c = JCloudsCloud.getByName(cloud);
                        if (null == c) continue;
                        nodes = work.get((Object)cloud);
                        cs = c.newCompute();
                        if (null == cs) continue;
                        try {
                            LOGGER.info("Suspending stale nodes in cloud " + cloud + ": " + String.valueOf(nodes));
                            cs.suspendNodesMatching((Predicate)new Predicate<NodeMetadata>(){

                                public boolean apply(NodeMetadata input) {
                                    return null != input && nodes.contains(input.getId());
                                }
                            });
                        }
                        catch (Exception e) {
                            LOGGER.info("Suspending on cloud: " + cloud + "; nodes: " + String.valueOf(nodes) + ": " + String.valueOf(e));
                        }
                        cs.getContext().close();
                    }
                    work = p.getNodesToDestroy();
                    for (String cloud : work.keySet()) {
                        c = JCloudsCloud.getByName(cloud);
                        if (null == c) continue;
                        nodes = work.get((Object)cloud);
                        cs = c.newCompute();
                        if (null == cs) continue;
                        try {
                            LOGGER.info("Destroying stale nodes in cloud " + cloud + ": " + String.valueOf(nodes));
                            cs.destroyNodesMatching((Predicate)new Predicate<NodeMetadata>(){

                                public boolean apply(NodeMetadata input) {
                                    return null != input && nodes.contains(input.getId());
                                }
                            });
                        }
                        catch (Exception e) {
                            LOGGER.info("Destroying on cloud: " + cloud + "; nodes: " + String.valueOf(nodes) + ": " + String.valueOf(e));
                        }
                        cs.getContext().close();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Stale node cleanup", e);
                }
                p.remove();
            }
        }
    }

    private List<Path> listStaleNodeLists() {
        ArrayList<Path> ret = new ArrayList<Path>();
        Path jroot = Jenkins.get().getRootDir().toPath();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(jroot, STALE_PATTERN);){
            for (Path entry : ds) {
                ret.add(entry);
            }
        }
        catch (Exception ex) {
            if (ex instanceof DirectoryIteratorException) {
                LOGGER.warning("Could not iterate jenkins root: " + String.valueOf(ex.getCause()));
            }
            LOGGER.warning("Could not iterate jenkins root: " + String.valueOf(ex));
        }
        return ret;
    }
}

