/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import au.com.bytecode.opencsv.CSVReader;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.trilead.ssh2.Connection;
import edazdarevic.commons.net.CIDRUtils;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import jenkins.plugins.jclouds.compute.UserData;
import jenkins.plugins.jclouds.compute.internal.JCloudsNodeMetadata;
import jenkins.plugins.jclouds.config.ConfigHelper;
import jenkins.plugins.jclouds.internal.CredentialsHelper;
import jenkins.plugins.jclouds.internal.SSHPublicKeyExtractor;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.jclouds.aws.ec2.compute.AWSEC2TemplateOptions;
import org.jclouds.cloudstack.compute.options.CloudStackTemplateOptions;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.compute.options.DigitalOcean2TemplateOptions;
import org.jclouds.digitalocean2.domain.Key;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.googlecomputeengine.compute.options.GoogleComputeEngineTemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.predicates.validators.DnsNameValidator;
import org.jclouds.scriptbuilder.domain.Statement;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class JCloudsSlaveTemplate
extends AbstractDescribableImpl<JCloudsSlaveTemplate>
implements Supplier<JCloudsNodeMetadata> {
    private static final Logger LOGGER = Logger.getLogger(JCloudsSlaveTemplate.class.getName());
    private static final char SEPARATOR_CHAR = ',';
    public final String name;
    public final String imageId;
    public final String imageNameRegex;
    public final String hardwareId;
    public final double cores;
    public final int ram;
    public final String osFamily;
    public final String labelString;
    public final String description;
    public final String osVersion;
    public final String locationId;
    @Deprecated
    private transient String initScript;
    @Deprecated
    private transient String userData;
    public final int numExecutors;
    public final boolean stopOnTerminate;
    @Deprecated
    private transient String vmUser;
    @Deprecated
    private transient String vmPassword;
    private final String jvmOptions;
    public final boolean preExistingJenkinsUser;
    @Deprecated
    private transient String jenkinsUser;
    private final String fsRoot;
    public final boolean allowSudo;
    public final boolean installPrivateKey;
    public final Integer overrideRetentionTime;
    public final int spoolDelayMs;
    private transient Object delayLockObject = new Object();
    @Deprecated
    private transient Boolean assignFloatingIp;
    public final boolean waitPhoneHome;
    public final int waitPhoneHomeTimeout;
    public final String keyPairName;
    public final boolean assignPublicIp;
    public final String networks;
    public final String securityGroups;
    public final Node.Mode mode;
    public final boolean useConfigDrive;
    public final boolean isPreemptible;
    private final String credentialsId;
    private final String adminCredentialsId;
    private final List<UserData> userDataEntries;
    private final String initScriptId;
    private final String preferredAddress;
    private final boolean useJnlp;
    private final boolean jnlpProvision;
    private transient JCloudsCloud cloud;
    private transient Set<LabelAtom> labelSet;

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getAdminCredentialsId() {
        return this.adminCredentialsId;
    }

    public List<UserData> getUserDataEntries() {
        return this.userDataEntries;
    }

    public String getInitScriptId() {
        return this.initScriptId;
    }

    public String getPreferredAddress() {
        return this.preferredAddress;
    }

    public String getShortDescription() {
        return this.description.replaceFirst("(?s)[\r\n].*", " ...");
    }

    public boolean getUseJnlp() {
        return this.useJnlp;
    }

    public boolean getJnlpProvision() {
        return this.jnlpProvision;
    }

    @NonNull
    public String getUrl() {
        return "template/" + Util.rawEncode((String)this.name) + "/";
    }

    @DataBoundConstructor
    public JCloudsSlaveTemplate(String name, String imageId, String imageNameRegex, String hardwareId, double cores, int ram, String osFamily, String osVersion, String locationId, String labelString, String description, String initScriptId, int numExecutors, boolean stopOnTerminate, String jvmOptions, boolean preExistingJenkinsUser, String fsRoot, boolean allowSudo, boolean installPrivateKey, Integer overrideRetentionTime, boolean hasOverrideRetentionTime, int spoolDelayMs, boolean assignFloatingIp, boolean waitPhoneHome, int waitPhoneHomeTimeout, String keyPairName, boolean assignPublicIp, String networks, String securityGroups, String credentialsId, String adminCredentialsId, String mode, boolean useConfigDrive, boolean isPreemptible, List<UserData> userDataEntries, String preferredAddress, boolean useJnlp, boolean jnlpProvision) {
        this.name = Util.fixEmptyAndTrim((String)name);
        this.imageId = Util.fixEmptyAndTrim((String)imageId);
        this.imageNameRegex = Util.fixEmptyAndTrim((String)imageNameRegex);
        this.hardwareId = Util.fixEmptyAndTrim((String)hardwareId);
        this.cores = cores;
        this.ram = ram;
        this.osFamily = Util.fixNull((String)osFamily);
        this.osVersion = Util.fixNull((String)osVersion);
        this.locationId = Util.fixEmptyAndTrim((String)locationId);
        this.labelString = Util.fixNull((String)labelString);
        this.description = Util.fixNull((String)description);
        this.initScriptId = Util.fixNull((String)initScriptId);
        this.numExecutors = numExecutors;
        this.jvmOptions = Util.fixEmptyAndTrim((String)jvmOptions);
        this.stopOnTerminate = stopOnTerminate;
        this.preExistingJenkinsUser = preExistingJenkinsUser;
        this.fsRoot = Util.fixEmptyAndTrim((String)fsRoot);
        this.allowSudo = allowSudo;
        this.installPrivateKey = installPrivateKey;
        this.overrideRetentionTime = hasOverrideRetentionTime ? overrideRetentionTime : null;
        this.spoolDelayMs = spoolDelayMs;
        this.assignFloatingIp = assignFloatingIp;
        this.waitPhoneHome = waitPhoneHome;
        this.waitPhoneHomeTimeout = waitPhoneHomeTimeout;
        this.keyPairName = keyPairName;
        this.assignPublicIp = assignPublicIp;
        this.networks = networks;
        this.securityGroups = securityGroups;
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
        this.adminCredentialsId = Util.fixEmptyAndTrim((String)adminCredentialsId);
        this.mode = Node.Mode.valueOf((String)Util.fixNull((String)mode));
        this.useConfigDrive = useConfigDrive;
        this.isPreemptible = isPreemptible;
        this.userDataEntries = userDataEntries;
        this.preferredAddress = preferredAddress;
        this.useJnlp = useJnlp;
        this.jnlpProvision = jnlpProvision;
        this.readResolve();
        this.userData = null;
        this.vmPassword = null;
        this.vmUser = null;
    }

    public JCloudsCloud getCloud() {
        return this.cloud;
    }

    public void setCloud(JCloudsCloud c) {
        this.cloud = c;
    }

    protected Object readResolve() {
        this.labelSet = Label.parse((String)this.labelString);
        return this;
    }

    public String getJenkinsUser() {
        if (!JCloudsSlaveTemplate.isNullOrEmpty(this.jenkinsUser)) {
            return this.jenkinsUser;
        }
        StandardUsernameCredentials u = CredentialsHelper.getCredentialsById(this.credentialsId);
        if (null == u || JCloudsSlaveTemplate.isNullOrEmpty(u.getUsername())) {
            return "jenkins";
        }
        return u.getUsername();
    }

    public String getJenkinsPrivateKey() {
        if (JCloudsSlaveTemplate.isNullOrEmpty(this.credentialsId)) {
            return this.getCloud().getGlobalPrivateKey();
        }
        SSHUserPrivateKey supk = (SSHUserPrivateKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(SSHUserPrivateKey.class, null, null), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
        if (null == supk) {
            LOGGER.warning(String.format("Credentials with id %s not found", this.credentialsId));
            return "---id not found---";
        }
        return CredentialsHelper.getPrivateKey(supk);
    }

    public String getJenkinsPublicKey() {
        try {
            return SSHPublicKeyExtractor.extract(this.getJenkinsPrivateKey(), null);
        }
        catch (IOException e) {
            LOGGER.warning(String.format("Error while extracting public key: %s", e));
            return "";
        }
    }

    public String getAdminUser() {
        if (!JCloudsSlaveTemplate.isNullOrEmpty(this.vmUser)) {
            return this.vmUser;
        }
        StandardUsernameCredentials u = CredentialsHelper.getCredentialsById(this.adminCredentialsId);
        if (null == u || JCloudsSlaveTemplate.isNullOrEmpty(u.getUsername())) {
            return "root";
        }
        return u.getUsername();
    }

    public String getJvmOptions() {
        return Util.fixNull((String)this.jvmOptions);
    }

    public int getNumExecutors() {
        return this.numExecutors;
    }

    public String getFsRoot() {
        if (this.fsRoot == null || this.fsRoot.equals("")) {
            return "/jenkins";
        }
        return this.fsRoot;
    }

    public Set<LabelAtom> getLabelSet() {
        return this.labelSet;
    }

    private String generateNonce() {
        Random r = new Random(System.currentTimeMillis());
        StringBuilder ret = new StringBuilder();
        while (16 > ret.length()) {
            char ch = (char)(97 + r.nextInt(26));
            ret.append(ch);
        }
        return ret.toString();
    }

    public JCloudsSlave provisionSlave(TaskListener listener, ProvisioningActivity.Id provisioningId) throws IOException {
        JCloudsNodeMetadata nmd = this.get();
        try {
            return new JCloudsSlave(provisioningId, this.getCloud().getDisplayName(), this.getFsRoot(), nmd, this.labelString, this.description, Integer.toString(this.numExecutors), this.stopOnTerminate, this.overrideRetentionTime, this.getJvmOptions(), this.waitPhoneHome, this.waitPhoneHomeTimeout, this.credentialsId, this.mode, this.preferredAddress, this.useJnlp, this.jnlpProvision, nmd.getNonce());
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError((Object)("Invalid configuration " + e.getMessage()));
        }
    }

    public List<String> getUserDataIds() {
        ArrayList<String> ret = new ArrayList<String>();
        if (null != this.userDataEntries) {
            for (UserData ud : this.userDataEntries) {
                ret.add(ud.fileId);
            }
        }
        return ret;
    }

    private void setUserData(@NonNull TemplateOptions options, @Nullable byte[] udata, boolean isZipped) {
        if (null != udata) {
            String logdata;
            String sudata = new String(udata, StandardCharsets.UTF_8);
            String string = logdata = isZipped ? String.format("<%d bytes of zip data>", udata.length) : sudata;
            if (options instanceof GoogleComputeEngineTemplateOptions) {
                LOGGER.finest("Setting userData to " + logdata);
                options.userMetadata("user-data", sudata);
            } else if (options instanceof DigitalOcean2TemplateOptions) {
                LOGGER.finest("Setting userData to " + logdata);
                options.userMetadata("user_data", sudata);
            } else {
                try {
                    Method userDataMethod = options.getClass().getMethod("userData", new byte[0].getClass());
                    LOGGER.finest("Setting userData to " + logdata);
                    userDataMethod.invoke((Object)options, new Object[]{udata});
                }
                catch (ReflectiveOperationException e) {
                    LOGGER.log(Level.WARNING, "userData is not supported by provider options class " + options.getClass().getName(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCloudsNodeMetadata get() {
        String nonce = this.generateNonce();
        boolean brokenImageCacheHasThrown = false;
        JCloudsNodeMetadata nmd = null;
        do {
            Object adminUser;
            LOGGER.info("Provisioning new jclouds node");
            ImmutableMap userMetadata = ImmutableMap.of((Object)"Name", (Object)this.name);
            TemplateBuilder templateBuilder = this.getCloud().getCompute().templateBuilder();
            if (!JCloudsSlaveTemplate.isNullOrEmpty(this.imageId)) {
                LOGGER.info("Setting image id to " + this.imageId);
                templateBuilder.imageId(this.imageId);
            } else if (!JCloudsSlaveTemplate.isNullOrEmpty(this.imageNameRegex)) {
                if (brokenImageCacheHasThrown) {
                    LOGGER.info("Resolving image name regex " + this.imageNameRegex);
                    boolean foundAny = true;
                    for (Image i : this.getCloud().newCompute().listImages()) {
                        if (!i.getName().matches(this.imageNameRegex)) continue;
                        LOGGER.info("Setting image id to " + i.getId());
                        templateBuilder.imageId(i.getId());
                        foundAny = true;
                        break;
                    }
                    if (!foundAny) {
                        throw new RuntimeException("No matching image available");
                    }
                } else {
                    LOGGER.info("Setting image name regex to " + this.imageNameRegex);
                    templateBuilder.imageNameMatches(this.imageNameRegex);
                }
            } else {
                if (!JCloudsSlaveTemplate.isNullOrEmpty(this.osFamily)) {
                    LOGGER.info("Setting osFamily to " + this.osFamily);
                    templateBuilder.osFamily(OsFamily.fromValue((String)this.osFamily));
                }
                if (!JCloudsSlaveTemplate.isNullOrEmpty(this.osVersion)) {
                    LOGGER.info("Setting osVersion to " + this.osVersion);
                    templateBuilder.osVersionMatches(this.osVersion);
                }
            }
            if (!JCloudsSlaveTemplate.isNullOrEmpty(this.hardwareId)) {
                LOGGER.info("Setting hardware Id to " + this.hardwareId);
                templateBuilder.hardwareId(this.hardwareId);
            } else {
                LOGGER.info("Setting minRam " + this.ram + " and minCores " + this.cores);
                templateBuilder.minCores(this.cores).minRam(this.ram);
            }
            if (!JCloudsSlaveTemplate.isNullOrEmpty(this.locationId)) {
                LOGGER.info("Setting location Id to " + this.locationId);
                templateBuilder.locationId(this.locationId);
            }
            Template template = templateBuilder.build();
            TemplateOptions options = template.getOptions();
            if (!JCloudsSlaveTemplate.isNullOrEmpty(this.networks)) {
                if (this.networks.startsWith("subnet-") && options instanceof AWSEC2TemplateOptions) {
                    LOGGER.info("Setting AWS EC2 subnetId to " + this.networks);
                    ((AWSEC2TemplateOptions)options.as(AWSEC2TemplateOptions.class)).subnetId(this.networks);
                } else {
                    LOGGER.info("Setting networks to " + this.networks);
                    options.networks(JCloudsSlaveTemplate.csvToArray(this.networks));
                }
            }
            if (!JCloudsSlaveTemplate.isNullOrEmpty(this.securityGroups)) {
                LOGGER.info("Setting security groups to " + this.securityGroups);
                options.securityGroups(JCloudsSlaveTemplate.csvToArray(this.securityGroups));
            }
            if (this.useConfigDrive && options instanceof NovaTemplateOptions) {
                ((NovaTemplateOptions)options.as(NovaTemplateOptions.class)).configDrive(true);
            }
            if (!JCloudsSlaveTemplate.isNullOrEmpty(this.keyPairName)) {
                if (options instanceof NovaTemplateOptions) {
                    LOGGER.info("Setting OpenStack keyPairName to: " + this.keyPairName);
                    ((NovaTemplateOptions)options.as(NovaTemplateOptions.class)).keyPairName(this.keyPairName);
                } else if (options instanceof CloudStackTemplateOptions) {
                    LOGGER.info("Setting CloudStack keyPairName to: " + this.keyPairName);
                    ((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).keyPair(this.keyPairName);
                } else if (options instanceof AWSEC2TemplateOptions) {
                    LOGGER.info("Setting AWS EC2 keyPairName to: " + this.keyPairName);
                    ((AWSEC2TemplateOptions)options.as(AWSEC2TemplateOptions.class)).keyPair(this.keyPairName);
                } else if (options instanceof DigitalOcean2TemplateOptions) {
                    try (DigitalOcean2Api do2api = this.getCloud().newApi(DigitalOcean2Api.class);){
                        Optional key = do2api.keyApi().list().concat().firstMatch((Predicate)new Predicate<Key>(){

                            public boolean apply(Key k) {
                                return null != k && JCloudsSlaveTemplate.this.keyPairName.equals(k.name());
                            }
                        });
                        if (key.isPresent()) {
                            Key k = (Key)key.get();
                            LOGGER.info(String.format("Setting DigitalOcean keyPairName to %s (%d)", this.keyPairName, k.id()));
                            ArrayList<Integer> kids = new ArrayList<Integer>();
                            kids.add(k.id());
                            ((DigitalOcean2TemplateOptions)options.as(DigitalOcean2TemplateOptions.class)).sshKeyIds(kids).autoCreateKeyPair(false);
                        } else {
                            LOGGER.warning(String.format("The specified keyPairName %s does not exist", this.keyPairName));
                        }
                    }
                    catch (IOException x) {
                        throw new IllegalArgumentException("Could not fetch list of keys", x);
                    }
                }
            }
            if (options instanceof GoogleComputeEngineTemplateOptions) {
                ((GoogleComputeEngineTemplateOptions)options.as(GoogleComputeEngineTemplateOptions.class)).autoCreateKeyPair(false);
                ((GoogleComputeEngineTemplateOptions)options.as(GoogleComputeEngineTemplateOptions.class)).preemptible(this.isPreemptible);
                ((GoogleComputeEngineTemplateOptions)options.as(GoogleComputeEngineTemplateOptions.class)).assignExternalIp(this.assignPublicIp);
            }
            if (this.assignPublicIp && options instanceof NovaTemplateOptions) {
                LOGGER.info("Setting autoAssignFloatingIp to true");
                ((NovaTemplateOptions)options.as(NovaTemplateOptions.class)).autoAssignFloatingIp(true);
            }
            if (options instanceof CloudStackTemplateOptions) {
                LOGGER.info(String.format("Setting CloudStack setupStaticNat to %b", this.assignPublicIp));
                ((CloudStackTemplateOptions)options.as(CloudStackTemplateOptions.class)).setupStaticNat(this.assignPublicIp);
            }
            if (null != this.adminCredentialsId) {
                LOGGER.info("Setting adminCredentialsId to " + this.adminCredentialsId);
                adminUser = this.getAdminUser();
                StandardUsernameCredentials c = CredentialsHelper.getCredentialsById(this.adminCredentialsId);
                if (null != c) {
                    if (c instanceof StandardUsernamePasswordCredentials) {
                        LOGGER.info("Using username/password as adminCredentials");
                        String password = CredentialsHelper.getPassword(((StandardUsernamePasswordCredentials)c).getPassword());
                        lc = LoginCredentials.builder().user((String)adminUser).password(password).build();
                        options.overrideLoginCredentials(lc);
                    } else {
                        LOGGER.info("Using username/privatekey as adminCredentials");
                        String privateKey = CredentialsHelper.getPrivateKey((SSHUserPrivateKey)c);
                        lc = LoginCredentials.builder().user((String)adminUser).privateKey(privateKey).build();
                        options.overrideLoginCredentials(lc);
                    }
                }
            }
            if (this.spoolDelayMs > 0) {
                adminUser = this.delayLockObject;
                synchronized (adminUser) {
                    LOGGER.info("Delaying " + this.spoolDelayMs + " milliseconds. Current ms -> " + System.currentTimeMillis());
                    try {
                        this.delayLockObject.wait(this.spoolDelayMs);
                    }
                    catch (InterruptedException e) {
                        LOGGER.warning(e.getMessage());
                    }
                }
            }
            Statement initStatement = null;
            String initscript = ConfigHelper.getConfig(this.initScriptId);
            if (this.preExistingJenkinsUser) {
                if (!initscript.isEmpty()) {
                    initStatement = Statements.exec((String)initscript);
                }
            } else {
                AdminAccess adminAccess = AdminAccess.builder().adminUsername(this.getJenkinsUser()).installAdminPrivateKey(this.installPrivateKey).grantSudoToAdminUser(this.allowSudo).adminPrivateKey(this.getJenkinsPrivateKey()).authorizeAdminPublicKey(true).adminPublicKey(this.getJenkinsPublicKey()).adminHome(this.getFsRoot()).build();
                Statement jenkinsDirStatement = Statements.newStatementList((Statement[])new Statement[]{Statements.exec((String)("mkdir -p " + this.getFsRoot())), Statements.exec((String)("chown " + this.getJenkinsUser() + " " + this.getFsRoot()))});
                initStatement = Statements.newStatementList((Statement[])new Statement[]{adminAccess, jenkinsDirStatement, Statements.exec((String)initscript)});
            }
            options.inboundPorts(new int[]{22}).userMetadata((Map)userMetadata);
            if (null != initStatement) {
                if (!options.hasLoginPrivateKey()) {
                    LOGGER.info("Init script without private admin key. Falling back to jenkins user credentials");
                    LoginCredentials lc = LoginCredentials.builder().user(this.getJenkinsUser()).privateKey(this.getJenkinsPrivateKey()).build();
                    options.overrideLoginCredentials(lc);
                }
                options.runScript(initStatement);
            }
            if (null != this.userDataEntries) {
                HashMap<String, String> replacements = null;
                if (this.jnlpProvision) {
                    String rootUrl = Jenkins.get().getRootUrl();
                    if (null == rootUrl) {
                        rootUrl = "";
                    }
                    replacements = new HashMap<String, String>();
                    replacements.put("JNLP_NONCE", nonce);
                    replacements.put("JENKINS_ROOTURL", rootUrl);
                }
                try {
                    byte[] zipped;
                    boolean isZipped = false;
                    byte[] udata = ConfigHelper.buildUserData(this.getUserDataIds(), replacements, false);
                    if (null != udata && this.getCloud().allowGzippedUserData() && null != (zipped = ConfigHelper.buildUserData(this.getUserDataIds(), replacements, true)) && zipped.length < udata.length) {
                        udata = zipped;
                        isZipped = true;
                    }
                    this.setUserData(options, udata, isZipped);
                }
                catch (IOException x) {
                    LOGGER.log(Level.SEVERE, "Unable to build userData", x);
                }
            }
            try {
                nmd = JCloudsNodeMetadata.fromNodeMetadata((NodeMetadata)Iterables.getOnlyElement((Iterable)this.getCloud().getCompute().createNodesInGroup(this.getCloud().prependGroupPrefix(this.name), 1, template)), nonce);
                brokenImageCacheHasThrown = false;
            }
            catch (RunNodesException e) {
                boolean throwNow = true;
                if (!JCloudsSlaveTemplate.isNullOrEmpty(this.imageNameRegex) && !brokenImageCacheHasThrown) {
                    Map xmap = e.getExecutionErrors();
                    for (Throwable t : xmap.values()) {
                        if (t.getMessage().contains("Image")) {
                            LOGGER.fine("Exception message MATCHED: '" + t.getMessage() + "'");
                            brokenImageCacheHasThrown = true;
                            throwNow = false;
                            this.destroyBadNodes(e);
                            break;
                        }
                        LOGGER.fine("Exception message NOT MATCHED: '" + t.getMessage() + "'");
                    }
                }
                if (!throwNow) continue;
                this.destroyBadNodesAndPropagate(e);
            }
        } while (brokenImageCacheHasThrown);
        return nmd;
    }

    private void destroyBadNodes(RunNodesException e) {
        for (Map.Entry nodeError : e.getNodeErrors().entrySet()) {
            this.getCloud().getCompute().destroyNode(((NodeMetadata)nodeError.getKey()).getId());
        }
    }

    private void destroyBadNodesAndPropagate(RunNodesException e) {
        this.destroyBadNodes(e);
        throw new RuntimeException(e);
    }

    private static String[] csvToArray(String csv) {
        try {
            CSVReader reader = new CSVReader((Reader)new StringReader(csv), ',');
            String[] line = reader.readNext();
            return line != null ? line : new String[]{};
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public boolean hasOverrideRetentionTime() {
        return null != this.overrideRetentionTime;
    }

    @POST
    public HttpResponse doDoDelete(@AncestorInPath JCloudsCloud c) throws IOException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        if (null == c) {
            throw new IllegalStateException("Cloud could not be found");
        }
        c.removeTemplate(this);
        j.save();
        return new HttpRedirect("../../templates");
    }

    @POST
    public HttpResponse doConfigSubmit(StaplerRequest2 req, @AncestorInPath JCloudsCloud c) throws IOException, ServletException, Descriptor.FormException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        if (null == c) {
            throw new IllegalStateException("Cloud could not be found");
        }
        JCloudsSlaveTemplate tpl = this.reconfigure(req, req.getSubmittedForm());
        if (JCloudsSlaveTemplate.isNullOrEmpty(tpl.name)) {
            throw new Descriptor.FormException("Template name is mandatory", "name");
        }
        c.replaceTemplate(this, tpl);
        j.save();
        return FormApply.success((String)"../../templates");
    }

    private JCloudsSlaveTemplate reconfigure(@NonNull StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        return null == form ? null : (JCloudsSlaveTemplate)this.getDescriptor().newInstance(req, form);
    }

    private void setFinal(String fieldName, Object newValue) throws ReflectiveOperationException {
        Field field = ((Object)((Object)this)).getClass().getDeclaredField(fieldName);
        if ((field.getModifiers() & 0x10) != 0) {
            Field modifiers = Field.class.getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set((Object)this, newValue);
            modifiers.setInt(field, field.getModifiers() | 0x10);
            modifiers.setAccessible(false);
        } else {
            field.set((Object)this, newValue);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION", "NP_NULL_ON_SOME_PATH"}, justification="false positives")
    boolean upgrade() {
        boolean any = false;
        try {
            if (this.getCloud().providerName.equals("openstack-nova") && null != this.assignFloatingIp) {
                LOGGER.info("Upgrading config data: assignFloatingIp");
                this.setFinal("assignPublicIp", this.assignFloatingIp);
                this.assignFloatingIp = null;
                any = true;
            }
            String description = "JClouds cloud " + this.getCloud().name + "." + this.name + " - auto-migrated";
            String ju = this.getJenkinsUser();
            if (JCloudsSlaveTemplate.isNullOrEmpty(this.getCredentialsId()) && !JCloudsSlaveTemplate.isNullOrEmpty(ju)) {
                LOGGER.info("Upgrading config data: jenkins credentals -> via credentials plugin");
                this.setFinal("credentialsId", this.convertJenkinsUser(ju, description, this.getCloud().getGlobalPrivateKey()));
                this.jenkinsUser = null;
                any = true;
            }
            if (JCloudsSlaveTemplate.isNullOrEmpty(this.getAdminCredentialsId()) && !JCloudsSlaveTemplate.isNullOrEmpty(this.vmUser)) {
                LOGGER.info("Upgrading config data: admin credentals -> via credentials plugin");
                UsernamePasswordCredentialsImpl u = null;
                String au = this.getAdminUser();
                if (JCloudsSlaveTemplate.isNullOrEmpty(this.vmPassword)) {
                    if (!au.equals("root")) {
                        String privateKey = this.getCloud().getGlobalPrivateKey();
                        u = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, null, au, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey), null, description);
                    }
                } else {
                    u = new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, null, description, au, this.vmPassword);
                }
                try {
                    this.setFinal("adminCredentialsId", CredentialsHelper.storeCredentials(u));
                    any = true;
                }
                catch (IOException x) {
                    LOGGER.warning(String.format("Error while saving credentials: %s", x.getMessage()));
                }
            }
            if (!JCloudsSlaveTemplate.isNullOrEmpty(this.userData)) {
                LOGGER.info("Upgrading config data: userData -> via config-file-provider");
                UserData ud = UserData.createFromData(this.userData, this.getCloud().name + "." + this.name + ".cfg");
                if (null == this.userDataEntries) {
                    this.setFinal("userDataEntries", new ArrayList());
                    any = true;
                }
                this.userDataEntries.add(ud);
                this.userData = null;
            }
            if (!JCloudsSlaveTemplate.isNullOrEmpty(this.initScript)) {
                LOGGER.info("Upgrading config data: initScript -> via config-file-provider");
                this.setFinal("initScriptId", UserData.createFromData((String)this.initScript, (String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001.\u0001.sh"}, (String)this.getCloud().name, (String)this.name))).fileId);
                any = true;
                this.initScript = null;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new IllegalStateException("Could not upgrade config data", e);
        }
        return any;
    }

    @CheckForNull
    private String convertJenkinsUser(String user, String description, String privateKey) {
        StandardUsernameCredentials u = this.retrieveExistingCredentials(user, privateKey);
        if (null == u) {
            u = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, null, user, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey), null, description);
            try {
                return CredentialsHelper.storeCredentials(u);
            }
            catch (IOException x) {
                LOGGER.warning(String.format("Error while saving credentials: %s", x.getMessage()));
                return null;
            }
        }
        return u.getId();
    }

    private StandardUsernameCredentials retrieveExistingCredentials(String username, final String privkey) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(SSHUserPrivateKey.class, null, null, Collections.singletonList(SSHLauncher.SSH_SCHEME)), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withUsername((String)username), new CredentialsMatcher(){

            public boolean matches(Credentials item) {
                for (String key : ((SSHUserPrivateKey)SSHUserPrivateKey.class.cast(item)).getPrivateKeys()) {
                    if (!JCloudsSlaveTemplate.this.pemKeyEquals(key, privkey)) continue;
                    return true;
                }
                return false;
            }
        }}));
    }

    private boolean pemKeyEquals(String key1, String key2) {
        key1 = key1.trim();
        key2 = key2.trim();
        return key1.replaceAll("\\s+", "").equals(key2.replace("\\s+", "")) || Arrays.equals(this.quickNDirtyExtract(key1), this.quickNDirtyExtract(key2));
    }

    private byte[] quickNDirtyExtract(String key) {
        StringBuilder builder = new StringBuilder(key.length());
        boolean begin = false;
        boolean header = false;
        for (String line : key.split("\\n")) {
            if ((line = line.trim()).startsWith("---") && line.endsWith("---")) {
                if (begin && line.contains("---END")) break;
                if (!begin && line.contains("---BEGIN")) {
                    header = true;
                    begin = true;
                    continue;
                }
            }
            if (line == null || line.isBlank()) {
                header = false;
                continue;
            }
            if (header) continue;
            builder.append(line);
        }
        return Base64.decodeBase64((String)builder.toString());
    }

    static boolean isNullOrEmpty(String value) {
        return null == Util.fixEmptyAndTrim((String)value);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<JCloudsSlaveTemplate> {
        public String getDisplayName() {
            return "JCloudsSlaveTemplate";
        }

        public boolean isUserDataSupported(String cloudName) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            return null != c && c.isUserDataSupported();
        }

        @POST
        public FormValidation doCheckPreferredAddress(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                if (!JCloudsSlaveTemplate.isNullOrEmpty(value)) {
                    new CIDRUtils(value);
                }
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        @POST
        public FormValidation doCheckName(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                new DnsNameValidator(1, 80).validate(value);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        @POST
        public FormValidation doCheckCores(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            FormValidation ret = FormValidation.validateRequired((String)value);
            if (ret == FormValidation.ok()) {
                try {
                    int ival = Integer.parseInt(value);
                    if (ival < 0) {
                        return FormValidation.error((String)"Value must not be negative");
                    }
                    return ret;
                }
                catch (NumberFormatException x) {
                    List<String> sval = Arrays.asList(value.split("\\.", -1));
                    if (sval.size() != 2) {
                        return FormValidation.error((String)"Not a number");
                    }
                    for (String s : sval) {
                        try {
                            int ival = Integer.parseInt(s);
                            if (ival >= 0) continue;
                            return FormValidation.error((String)"Value must not be negative");
                        }
                        catch (NumberFormatException x2) {
                            return FormValidation.error((String)"Not a number");
                        }
                    }
                }
            }
            return ret;
        }

        @POST
        public FormValidation doCheckRam(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        @POST
        public AutoCompletionCandidates doAutoCompleteOsFamily(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            OsFamily[] osFamilies = OsFamily.values();
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            for (OsFamily osFamily : osFamilies) {
                if (!osFamily.toString().matches("(?i).*\\Q" + value + "\\E.*")) continue;
                candidates.add(osFamily.toString());
            }
            return candidates;
        }

        private FormValidation deprecatedSshProvisioning() {
            return FormValidation.warningWithMarkup((String)"Using SSH-based provisioning is deprecated and will be removed in a future version.<br/>Please use cloud-init for provisioning a jenkins user");
        }

        @POST
        public FormValidation doCheckNumExecutors(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        @POST
        public FormValidation doCheckCredentialsId(@QueryParameter String value, @QueryParameter boolean useJnlp) {
            return useJnlp ? FormValidation.ok() : FormValidation.validateRequired((String)value);
        }

        @POST
        public FormValidation doCheckAllowSudo(@QueryParameter boolean value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return value ? this.deprecatedSshProvisioning() : FormValidation.ok();
        }

        @POST
        public FormValidation doCheckInstallPrivateKey(@QueryParameter boolean value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return value ? this.deprecatedSshProvisioning() : FormValidation.ok();
        }

        @POST
        public FormValidation doCheckPreExistingJenkinsUser(@QueryParameter String value, @QueryParameter String useJnlp) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (!Boolean.valueOf(Util.fixEmptyAndTrim((String)value)).booleanValue()) {
                if (Boolean.valueOf(Util.fixEmptyAndTrim((String)useJnlp)).booleanValue()) {
                    return FormValidation.error((String)"Jenkins user provisioning relies on posix system, accessible via SSH.");
                }
                return this.deprecatedSshProvisioning();
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUseJnlp(@QueryParameter boolean value, @QueryParameter boolean preExistingJenkinsUser, @QueryParameter String initScriptId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (value) {
                if (null == Jenkins.get().getTcpSlaveAgentListener() || -1 == Jenkins.get().getSlaveAgentPort()) {
                    return FormValidation.error((String)"This feature cannot work, because the JNLP port is disabled in global security.");
                }
                Set aps = Jenkins.get().getAgentProtocols();
                if (!(aps.contains("JNLP-connect") || aps.contains("JNLP2-connect") || aps.contains("JNLP3-connect") || aps.contains("JNLP4-connect"))) {
                    return FormValidation.error((String)"This feature cannot work, because all JNLP protocols are disabled in global security.");
                }
                if (!preExistingJenkinsUser) {
                    return FormValidation.error((String)"Jenkins user provisioning relies on posix system, accessible via SSH.");
                }
                if (!ConfigHelper.getConfig(initScriptId).isEmpty()) {
                    return FormValidation.error((String)"Init script functionality relies on a posix system, accessible via SSH.");
                }
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckAdminCredentialsId(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (JCloudsSlaveTemplate.isNullOrEmpty(value)) {
                return FormValidation.ok();
            }
            StandardUsernameCredentials suc = CredentialsHelper.getCredentialsById(value);
            if (null == suc) {
                return FormValidation.error((String)"Credentials with id %s not found", (Object[])new Object[]{value});
            }
            if (!CredentialsHelper.isRSACredential(value)) {
                return FormValidation.error((String)"Not an RSA SSH key credential");
            }
            return this.deprecatedSshProvisioning();
        }

        @POST
        public FormValidation doCheckInitScriptId(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (JCloudsSlaveTemplate.isNullOrEmpty(value)) {
                return FormValidation.ok();
            }
            return this.deprecatedSshProvisioning();
        }

        @POST
        public FormValidation doCheckFsRoot(@QueryParameter String value, @QueryParameter boolean preExistingJenkinsUser) {
            if (preExistingJenkinsUser) {
                return FormValidation.ok();
            }
            return FormValidation.validateRequired((String)value);
        }

        @POST
        public FormValidation doValidateImageId(@QueryParameter String cloudName, @QueryParameter String imageId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            if (null == c) {
                return FormValidation.error((String)"Unable to find parent cloud");
            }
            return c.validateImageId(imageId);
        }

        @POST
        public FormValidation doValidateImageNameRegex(@QueryParameter(value="cloudName") String cloudName, @QueryParameter String imageNameRegex) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            if (null == c) {
                return FormValidation.error((String)"Unable to find parent cloud");
            }
            return c.validateImageNameRegex(imageNameRegex);
        }

        @POST
        public FormValidation doValidateHardwareId(@QueryParameter String cloudName, @QueryParameter String hardwareId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            if (null == c) {
                return FormValidation.error((String)"Unable to find parent cloud");
            }
            return c.validateHardwareId(hardwareId);
        }

        @POST
        public FormValidation doValidateLocationId(@QueryParameter String cloudName, @QueryParameter String locationId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            if (null == c) {
                return FormValidation.error((String)"Unable to find parent cloud");
            }
            return c.validateLocationId(locationId);
        }

        private boolean prepareListBoxModel(ListBoxModel m) {
            m.add("None specified", "");
            return Boolean.getBoolean("underSurefireTest");
        }

        @POST
        public ListBoxModel doFillHardwareIdItems(@QueryParameter(value="cloudName") String cloudName) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel m = new ListBoxModel();
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            if (null == c || this.prepareListBoxModel(m)) {
                return m;
            }
            c.fillHardwareIdItems(m);
            return m;
        }

        @POST
        public ListBoxModel doFillLocationIdItems(@QueryParameter(value="cloudName") String cloudName) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel m = new ListBoxModel();
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            if (null == c || this.prepareListBoxModel(m)) {
                return m;
            }
            c.fillLocationIdItems(m);
            return m;
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String currentValue) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.get()).hasPermission(Computer.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(currentValue);
            }
            return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM2, context, StandardUsernameCredentials.class, Collections.singletonList(SSHLauncher.SSH_SCHEME), SSHAuthenticator.matcher(Connection.class)).includeCurrentValue(currentValue);
        }

        @POST
        public ListBoxModel doFillAdminCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String currentValue) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.get()).hasPermission(Computer.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(currentValue);
            }
            return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM2, context, StandardUsernameCredentials.class, Collections.singletonList(SSHLauncher.SSH_SCHEME), SSHAuthenticator.matcher(Connection.class)).includeCurrentValue(currentValue);
        }

        @POST
        @NonNull
        public ListBoxModel doFillInitScriptIdItems(@QueryParameter @Nullable String currentValue) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return ConfigHelper.doFillInitScriptItems(currentValue);
        }

        @POST
        public FormValidation doCheckOverrideRetentionTime(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (JCloudsSlaveTemplate.isNullOrEmpty(value)) {
                return FormValidation.ok();
            }
            try {
                if (Integer.parseInt(value) == -1) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.validateNonNegativeInteger((String)value);
        }

        public FormValidation doCheckSpoolDelayMs(@QueryParameter String value) {
            return FormValidation.validateNonNegativeInteger((String)value);
        }
    }
}

