/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsComputer;
import jenkins.plugins.jclouds.compute.JCloudsJnlpLauncher;
import jenkins.plugins.jclouds.compute.JCloudsLauncher;
import jenkins.plugins.jclouds.compute.JCloudsRetentionStrategy;
import jenkins.plugins.jclouds.compute.MetaDataPublisher;
import jenkins.plugins.jclouds.compute.PhoneHomeMonitor;
import net.sf.json.JSONObject;
import org.apache.commons.codec.binary.Base64;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.LoginCredentials;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.kohsuke.stapler.DataBoundConstructor;

public class JCloudsSlave
extends AbstractCloudSlave
implements TrackedItem {
    private static final long serialVersionUID = 42L;
    private static final Logger LOGGER = Logger.getLogger(JCloudsSlave.class.getName());
    private ProvisioningActivity.Id provisioningId;
    private transient NodeMetadata nodeMetaData;
    public final boolean stopOnTerminate;
    private final String cloudName;
    private String nodeId;
    private boolean pendingDelete;
    private boolean waitPhoneHome;
    private Integer overrideRetentionTime;
    private final int waitPhoneHomeTimeout;
    private final transient String user;
    private final transient String password;
    private final transient String privateKey;
    private final boolean authSudo;
    private final String jvmOptions;
    private final String credentialsId;
    private final String preferredAddress;
    private final boolean useJnlp;
    private final boolean jnlpProvisioning;
    private String jnlpProvisioningNonce;
    private transient PhoneHomeMonitor phm;

    @DataBoundConstructor
    public JCloudsSlave(String cloudName, String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties, boolean stopOnTerminate, Integer overrideRetentionTime, String user, String password, String privateKey, boolean authSudo, String jvmOptions, boolean waitPhoneHome, int waitPhoneHomeTimeout, String credentialsId, String preferredAddress, boolean useJnlp, boolean jnlpProvisioning, String jnlpProvisioningNonce) throws Descriptor.FormException, IOException {
        super(name, remoteFS, launcher);
        this.setLabelString(labelString);
        this.setNodeDescription(nodeDescription);
        this.setNumExecutors(Integer.parseInt(numExecutors));
        this.setMode(mode);
        this.setRetentionStrategy(retentionStrategy);
        this.setNodeProperties(nodeProperties);
        this.stopOnTerminate = stopOnTerminate;
        this.cloudName = cloudName;
        this.overrideRetentionTime = overrideRetentionTime;
        this.user = user;
        this.password = password;
        this.privateKey = privateKey;
        this.authSudo = authSudo;
        this.jvmOptions = jvmOptions;
        this.waitPhoneHome = waitPhoneHome;
        this.waitPhoneHomeTimeout = waitPhoneHomeTimeout;
        this.credentialsId = credentialsId;
        this.preferredAddress = preferredAddress;
        this.useJnlp = useJnlp;
        this.jnlpProvisioning = jnlpProvisioning;
        this.jnlpProvisioningNonce = jnlpProvisioningNonce;
        this.phm = new PhoneHomeMonitor(waitPhoneHome, waitPhoneHomeTimeout);
    }

    protected Object readResolve() {
        if (null == this.phm) {
            this.phm = new PhoneHomeMonitor(this.waitPhoneHome, this.waitPhoneHomeTimeout);
        }
        return this;
    }

    public JCloudsSlave(String cloudName, String fsRoot, NodeMetadata metadata, String labelString, String description, String numExecutors, boolean stopOnTerminate, Integer overrideRetentionTime, String jvmOptions, boolean waitPhoneHome, int waitPhoneHomeTimeout, String credentialsId, Node.Mode mode, String preferredAddress, boolean useJnlp, boolean jnlpProvisioning, String jnlpProvisioningNonce) throws IOException, Descriptor.FormException {
        this(cloudName, JCloudsSlave.uniqueName(metadata, cloudName), description, fsRoot, numExecutors, mode, labelString, (ComputerLauncher)(useJnlp ? new JCloudsJnlpLauncher() : new JCloudsLauncher()), new JCloudsRetentionStrategy(), Collections.emptyList(), stopOnTerminate, overrideRetentionTime, metadata.getCredentials().getUser(), (String)metadata.getCredentials().getOptionalPassword().orNull(), (String)metadata.getCredentials().getOptionalPrivateKey().orNull(), metadata.getCredentials().shouldAuthenticateSudo(), jvmOptions, waitPhoneHome, waitPhoneHomeTimeout, credentialsId, preferredAddress, useJnlp, jnlpProvisioning, jnlpProvisioningNonce);
        this.nodeMetaData = metadata;
        this.nodeId = this.nodeMetaData.getId();
    }

    public JCloudsSlave(ProvisioningActivity.Id provisioningId, String cloudName, String fsRoot, NodeMetadata metadata, String labelString, String description, String numExecutors, boolean stopOnTerminate, Integer overrideRetentionTime, String jvmOptions, boolean waitPhoneHome, int waitPhoneHomeTimeout, String credentialsId, Node.Mode mode, String preferredAddress, boolean useJnlp, boolean jnlpProvisioning, String jnlpProvisioningNonce) throws IOException, Descriptor.FormException {
        this(cloudName, fsRoot, metadata, labelString, description, numExecutors, stopOnTerminate, overrideRetentionTime, jvmOptions, waitPhoneHome, waitPhoneHomeTimeout, credentialsId, mode, preferredAddress, useJnlp, jnlpProvisioning, jnlpProvisioningNonce);
        this.provisioningId = provisioningId;
    }

    static final String uniqueName(NodeMetadata md, String cloudName) {
        JCloudsCloud c = JCloudsCloud.getByName(cloudName);
        if (c.providerName.equals("aws-ec2")) {
            return md.getName() + "-" + md.getProviderId();
        }
        return md.getName();
    }

    @CheckForNull
    private String calculateJnlpProvisioningHash() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String src = this.jnlpProvisioningNonce + this.getNodeName();
            return Base64.encodeBase64String((byte[])md.digest(src.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException x) {
            LOGGER.severe("Should not happen: SHA256 digest algorithm not available");
            return null;
        }
    }

    private Map<String, String> getJnlpProperties() {
        SlaveComputer computer;
        HashMap<String, String> ret = new HashMap<String, String>();
        String rootUrl = Jenkins.get().getRootUrl();
        if (null == rootUrl) {
            rootUrl = "";
        }
        if (null != (computer = this.getComputer())) {
            ret.put("X-url", rootUrl + computer.getUrl() + "slave-agent.jnlp");
            ret.put("X-jenkinsurl", rootUrl);
            ret.put("X-jar", rootUrl + "jnlpJars/agent.jar");
            ret.put("X-sec", computer.getJnlpMac());
            ret.put("X-agentname", computer.getName());
            return ret;
        }
        LOGGER.severe("Should not happen: No associated SlaveComputer");
        return ret;
    }

    private String ToJsonString(Map<String, String> map) {
        JSONObject ret = new JSONObject();
        ret.putAll(map);
        return ret.toString();
    }

    public String handleJnlpProvisioning(@NonNull String hash) {
        if (this.jnlpProvisioning) {
            LOGGER.info("Handling JNLP provisioning request");
            String expectedHash = this.calculateJnlpProvisioningHash();
            if (null != expectedHash && expectedHash.equals(hash)) {
                LOGGER.info("Responding to JNLP provisioning request");
                return this.ToJsonString(this.getJnlpProperties());
            }
        }
        return "";
    }

    public void publishJnlpMetaData() {
        if (this.jnlpProvisioning) {
            MetaDataPublisher mdp = new MetaDataPublisher(JCloudsCloud.getByName(this.cloudName));
            mdp.publish(this.nodeId, "Publishing JNLP properties for ID " + this.nodeId, this.getJnlpProperties());
        }
    }

    public NodeMetadata getNodeMetaData() {
        if (this.nodeMetaData == null) {
            ComputeService compute = JCloudsCloud.getByName(this.cloudName).getCompute();
            this.nodeMetaData = compute.getNodeMetadata(this.nodeId);
        }
        return this.nodeMetaData;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public String getPreferredAddress() {
        return this.preferredAddress;
    }

    public boolean getJnlpProvisioning() {
        return this.jnlpProvisioning;
    }

    public boolean getUseJnlp() {
        return this.useJnlp;
    }

    public String getJnlpProvisioningNonce() {
        return this.jnlpProvisioningNonce;
    }

    public LoginCredentials getCredentials() {
        LoginCredentials credentials = this.getNodeMetaData().getCredentials();
        if (credentials == null) {
            LOGGER.info("Using credentials from CloudSlave instance");
            credentials = LoginCredentials.builder().user(this.user).password(this.password).privateKey(this.privateKey).authenticateSudo(this.authSudo).build();
        } else {
            LOGGER.info("Using credentials from JClouds");
        }
        return credentials;
    }

    public void setOverrideRetentionTime(Integer value) {
        this.overrideRetentionTime = value;
    }

    public int getRetentionTime() {
        if (null != this.overrideRetentionTime) {
            return this.overrideRetentionTime;
        }
        JCloudsCloud cloud = JCloudsCloud.getByName(this.cloudName);
        return cloud == null ? 30 : cloud.getRetentionTime();
    }

    int getErrorRetentionTime() {
        JCloudsCloud cloud = JCloudsCloud.getByName(this.cloudName);
        return cloud == null ? 0 : cloud.getErrorRetentionTime();
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public boolean isPendingDelete() {
        return this.pendingDelete;
    }

    public void setPendingDelete(boolean pendingDelete) {
        this.pendingDelete = pendingDelete;
        if (pendingDelete) {
            this.phm.interrupt();
        }
    }

    public boolean isWaitPhoneHome() {
        return this.waitPhoneHome;
    }

    private void updateNode() {
        Node n = Jenkins.get().getNode(this.getNodeName());
        try {
            if (!Jenkins.get().updateNode(n)) {
                LOGGER.warning("Unable to update non-existing node " + this.getNodeName());
            }
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
    }

    public void setWaitPhoneHome(boolean value) {
        this.waitPhoneHome = value;
        this.updateNode();
        if (!this.waitPhoneHome) {
            this.phm.ring();
        }
    }

    public void setJnlpProvisioningNonce(String value) {
        this.jnlpProvisioningNonce = value;
        this.updateNode();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public AbstractCloudComputer<JCloudsSlave> createComputer() {
        LOGGER.info("Creating a new JClouds agent");
        return new JCloudsComputer(this);
    }

    @Nullable
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
        ComputeService compute = JCloudsCloud.getByName(this.cloudName).getCompute();
        if (compute.getNodeMetadata(this.nodeId) != null && ((NodeMetadata.Status)compute.getNodeMetadata(this.nodeId).getStatus()).equals((Object)NodeMetadata.Status.RUNNING)) {
            if (this.stopOnTerminate) {
                LOGGER.info("Suspending node: " + this.getNodeName());
                compute.suspendNode(this.nodeId);
            } else {
                LOGGER.info("Terminating node: " + this.getNodeName());
                compute.destroyNode(this.nodeId);
            }
        } else {
            LOGGER.info("Node " + this.getNodeName() + " is already terminated.");
        }
        ProvisioningActivity activity = CloudStatistics.get().getActivityFor((TrackedItem)this);
        if (activity != null) {
            activity.enterIfNotAlready(ProvisioningActivity.Phase.COMPLETED);
        }
    }

    public void waitForPhoneHome(PrintStream logger) throws InterruptedException {
        try {
            this.phm.waitForPhoneHome(this.getNodeName(), logger);
        }
        catch (InterruptedException e) {
            this.setWaitPhoneHome(false);
            throw e;
        }
    }

    @Extension
    public static final class JCloudsSlaveDescriptor
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "JClouds agent";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

