/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import hudson.model.Descriptor;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsComputer;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;

public class JCloudsRetentionStrategy
extends RetentionStrategy<JCloudsComputer> {
    private transient ReentrantLock checkLock;
    private static final Logger LOGGER = Logger.getLogger(JCloudsRetentionStrategy.class.getName());

    @DataBoundConstructor
    public JCloudsRetentionStrategy() {
        this.readResolve();
    }

    private void fastTerminate(JCloudsComputer c) {
        if (!c.isOffline()) {
            LOGGER.info("Setting " + c.getName() + " to be deleted.");
            try {
                c.disconnect(OfflineCause.create((Localizable)Messages._DELETED_CAUSE())).get();
            }
            catch (Exception e) {
                LOGGER.info("Caught " + e.toString());
            }
        }
        c.deleteSlave(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long check(JCloudsComputer c) {
        if (!this.checkLock.tryLock()) {
            return 1L;
        }
        try {
            JCloudsSlave node = (JCloudsSlave)c.getNode();
            if (null != node && c.isIdle()) {
                if (node.isPendingDelete()) {
                    this.fastTerminate(c);
                } else if (!node.isWaitPhoneHome()) {
                    OfflineCause oc = c.getOfflineCause();
                    if (null != oc && oc instanceof OfflineCause.LaunchFailed) {
                        long failedMilliseconds;
                        int errorRetentionTime = c.getErrorRetentionTime();
                        if (errorRetentionTime >= 0 && (failedMilliseconds = System.currentTimeMillis() - oc.getTimestamp()) > TimeUnit.MINUTES.toMillis(errorRetentionTime)) {
                            LOGGER.info(String.format("Error retention time of %d min for %s has expired.", errorRetentionTime, c.getName()));
                            node.setPendingDelete(true);
                            this.fastTerminate(c);
                        }
                    } else {
                        long idleMilliseconds;
                        int retentionTime = c.getRetentionTime();
                        if (retentionTime > -1 && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit.MINUTES.toMillis(retentionTime)) {
                            LOGGER.info(String.format("Retention time of %d min for %s has expired.", retentionTime, c.getName()));
                            node.setPendingDelete(true);
                            this.fastTerminate(c);
                        }
                    }
                }
            }
        }
        finally {
            this.checkLock.unlock();
        }
        return 1L;
    }

    public void start(JCloudsComputer c) {
        c.connect(false);
    }

    protected Object readResolve() {
        this.checkLock = new ReentrantLock(false);
        return this;
    }

    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "JClouds";
        }
    }
}

