/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.OfflineCause;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsComputer;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;

public class JCloudsOneOffSlave
extends SimpleBuildWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JCloudsOneOffSlave.class.getName());

    @DataBoundConstructor
    public JCloudsOneOffSlave() {
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        context.setDisposer((SimpleBuildWrapper.Disposer)new JCloudsOneOffSlaveDisposer());
    }

    private static class JCloudsOneOffSlaveDisposer
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 1L;

        private JCloudsOneOffSlaveDisposer() {
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            Computer computer = workspace.toComputer();
            if (computer == null) {
                throw new IllegalStateException("Computer is null");
            }
            if (JCloudsComputer.class.isInstance(computer)) {
                String msg = "Taking single-use agent " + computer.getName() + " offline.";
                LOGGER.warning(msg);
                listener.getLogger().println(msg);
                computer.setTemporaryOfflineCause(OfflineCause.create((Localizable)Messages._ONE_OFF_CAUSE()));
                JCloudsSlave s = (JCloudsSlave)((JCloudsComputer)computer).getNode();
                if (null != s) {
                    s.setOverrideRetentionTime(0);
                }
            } else {
                listener.getLogger().println("Not a single-use agent, this is a " + String.valueOf(computer.getClass()));
            }
        }
    }

    @Extension
    @Symbol(value={"jcloudsOneOffAgent"})
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "JClouds Single-use agent";
        }

        public boolean isApplicable(AbstractProject item) {
            return true;
        }
    }
}

