/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.Permission;
import hudson.slaves.OfflineCause;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsComputer;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class JCloudsOfflineStep
extends Recorder
implements SimpleBuildStep {
    private final String message;
    private final String condition;

    @DataBoundConstructor
    public JCloudsOfflineStep(String message, String condition) {
        message = Util.fixEmptyAndTrim((String)message);
        if (message == null) {
            throw new IllegalArgumentException("A non-empty message is required");
        }
        this.message = message;
        if ((condition = Util.fixEmptyAndTrim((String)condition)) == null) {
            throw new IllegalArgumentException("A non-empty condition is required");
        }
        this.condition = condition;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCondition() {
        return this.condition;
    }

    private Result getConditionInternal() {
        return Result.fromString((String)this.condition);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean requiresWorkspace() {
        return false;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull EnvVars env, @NonNull TaskListener tl) throws InterruptedException, IOException {
        Result result = run.getResult();
        if (null == result) {
            tl.getLogger().append("NOTICE: ").println("Build has not (yet) a result");
            return;
        }
        if (result.isBetterThan(this.getConditionInternal())) {
            tl.getLogger().println("Skipping action, build result is " + result.toString());
            return;
        }
        String nodename = env.get("NODE_NAME", "");
        Object err = env.expand("Unable to set node ${NODE_NAME} offline: ");
        String causemsg = String.format("In build %s: %s", run.getExternalizableId(), env.expand(this.message));
        if (!nodename.isEmpty()) {
            Node node = Jenkins.get().getNode(nodename);
            if (null != node) {
                err = "Unable to set node " + ModelHyperlinkNote.encodeTo((Node)node) + " offline: ";
                Computer c = node.toComputer();
                if (null != c) {
                    if (JCloudsComputer.class.isInstance(c)) {
                        tl.getLogger().append("NOTICE: ").println("Setting node " + ModelHyperlinkNote.encodeTo((Node)node) + " offline");
                        OfflineCause.UserCause oc = new OfflineCause.UserCause(null, causemsg);
                        c.setTemporaryOfflineCause((OfflineCause)oc);
                        return;
                    }
                    tl.getLogger().append("WARNING: ").println((String)err + "Not a jclouds instance");
                    return;
                }
                tl.getLogger().append("WARNING: ").println((String)err + "Node has no associated Computer");
                return;
            }
            tl.getLogger().append("WARNING: ").println((String)err + "Node not found");
            return;
        }
        tl.getLogger().append("WARNING: ").println("Unable to set empty node offline");
    }

    @Extension
    @Symbol(value={"jcloudsTakeOffline"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return "Take current JClouds agent offline conditionally";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            for (String name : JCloudsCloud.getCloudNames()) {
                JCloudsCloud c = JCloudsCloud.getByName(name);
                if (c == null || c.getTemplates().size() <= 0) continue;
                return true;
            }
            return false;
        }

        @POST
        public FormValidation doCheckMessage(@AncestorInPath AbstractProject project, @QueryParameter String message) {
            if (null == project) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Permission.CONFIGURE);
            }
            Jenkins.get().checkPermission(Computer.DISCONNECT);
            if (Util.fixEmptyAndTrim((String)message) == null) {
                return FormValidation.error((String)"Message must be non-empty");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillConditionItems(@AncestorInPath AbstractProject project) {
            if (null == project) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Permission.CONFIGURE);
            }
            Jenkins.get().checkPermission(Computer.DISCONNECT);
            ListBoxModel items = new ListBoxModel();
            items.add(Result.UNSTABLE.toString(), Result.UNSTABLE.toString());
            items.add(Result.FAILURE.toString(), Result.FAILURE.toString());
            items.add(Result.ABORTED.toString(), Result.ABORTED.toString());
            return items;
        }
    }
}

