/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import edazdarevic.commons.net.CIDRUtils;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import org.jclouds.compute.domain.NodeMetadata;

public class JCloudsLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(JCloudsLauncher.class.getName());

    private static void invokeSSHLauncher(String address, String credentialsId, String jvmOptions, SlaveComputer agent, TaskListener listener) throws IOException {
        try {
            SSHLauncher launcher = new SSHLauncher(address, 22, credentialsId);
            launcher.setJvmOptions(jvmOptions);
            launcher.launch(agent, listener);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            throw new IOException(t);
        }
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        String address;
        PrintStream logger = listener.getLogger();
        JCloudsSlave slave = (JCloudsSlave)computer.getNode();
        if (null != slave) {
            address = JCloudsLauncher.getConnectionAddress(slave.getNodeMetaData(), logger, slave.getPreferredAddress());
            slave.waitForPhoneHome(logger);
            LOGGER.info("launch resumed");
            if (InetAddress.getByName(address).isAnyLocalAddress()) {
                LOGGER.severe("Invalid address 0.0.0.0, your host is most likely waiting for an ip address.");
                logger.println("Invalid address 0.0.0.0, your host is most likely waiting for an ip address.");
                throw new IOException("goto sleep");
            }
        } else {
            LOGGER.severe("Could not launch NULL agent.");
            throw new IOException("Could not launch NULL agent.");
        }
        JCloudsLauncher.invokeSSHLauncher(address, slave.getCredentialsId(), slave.getJvmOptions(), computer, listener);
    }

    public static String getConnectionAddress(NodeMetadata nodeMetadata, PrintStream logger, String preferredAddress) {
        if (null != preferredAddress && !preferredAddress.isEmpty()) {
            block8: {
                LOGGER.info("preferredAddress is " + preferredAddress);
                try {
                    CIDRUtils cu = new CIDRUtils(preferredAddress);
                    ArrayList addrs = new ArrayList();
                    addrs.addAll(nodeMetadata.getPublicAddresses());
                    addrs.addAll(nodeMetadata.getPrivateAddresses());
                    for (String addr : addrs) {
                        if (null != addr && !addr.isEmpty() && cu.isInRange(addr)) {
                            LOGGER.info(addr + " matches against " + preferredAddress);
                            return addr;
                        }
                        LOGGER.info(addr + " does NOT match against " + preferredAddress);
                    }
                }
                catch (UnknownHostException x) {
                    if (null == logger) break block8;
                    logger.println("Error during address match: " + x.getMessage());
                }
            }
            if (null != logger) {
                logger.println("Unable to match any address against " + preferredAddress + ". Falling back to simple selection.");
            }
        }
        if (nodeMetadata.getPublicAddresses().size() > 0) {
            return (String)nodeMetadata.getPublicAddresses().iterator().next();
        }
        if (null != logger) {
            logger.println("No public addresses found, so using private address.");
        }
        return (String)nodeMetadata.getPrivateAddresses().iterator().next();
    }

    public Descriptor<ComputerLauncher> getDescriptor() {
        throw new UnsupportedOperationException();
    }
}

