/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Node;
import hudson.remoting.VirtualChannel;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.Cloud;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsLauncher;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import org.jclouds.compute.domain.NodeMetadata;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.verb.POST;

public class JCloudsComputer
extends AbstractCloudComputer<JCloudsSlave>
implements TrackedItem {
    private static final Logger LOGGER = Logger.getLogger(JCloudsComputer.class.getName());
    private final ProvisioningActivity.Id provisioningId;

    public JCloudsComputer(JCloudsSlave slave) {
        super((AbstractCloudSlave)slave);
        this.provisioningId = slave.getId();
    }

    public String getInstanceId() {
        return this.getName();
    }

    public int getRetentionTime() {
        JCloudsSlave node = (JCloudsSlave)this.getNode();
        return null == node ? 30 : node.getRetentionTime();
    }

    int getErrorRetentionTime() {
        JCloudsSlave node = (JCloudsSlave)this.getNode();
        return null == node ? 0 : node.getErrorRetentionTime();
    }

    public boolean getIsPendingDelete() {
        JCloudsSlave node = (JCloudsSlave)this.getNode();
        return null != node && node.isPendingDelete();
    }

    @CheckForNull
    public String getCloudName() {
        JCloudsSlave node = (JCloudsSlave)this.getNode();
        return null == node ? null : node.getCloudName();
    }

    @POST
    public HttpResponse doDoDelete() throws IOException {
        Jenkins.get().checkPermission(Cloud.PROVISION);
        this.recordTermination();
        this.setTemporaryOfflineCause(OfflineCause.create((Localizable)Messages._DELETED_CAUSE()));
        JCloudsSlave node = (JCloudsSlave)this.getNode();
        if (null != node) {
            if (node.isPendingDelete()) {
                LOGGER.info("Agent already pending delete: " + this.getName());
                this.deleteSlave(true);
            } else {
                node.setPendingDelete(true);
            }
        }
        return new HttpRedirect("..");
    }

    public void deleteSlave() throws IOException, InterruptedException {
        if (this.isIdle()) {
            LOGGER.info("Deleting agent: " + this.getName());
            JCloudsSlave slave = (JCloudsSlave)this.getNode();
            if (null != slave) {
                VirtualChannel ch = slave.getChannel();
                if (null != ch) {
                    ch.close();
                }
                slave.terminate();
                Jenkins.get().removeNode((Node)slave);
            }
        } else {
            LOGGER.info(String.format("Agent %s is not idle, postponing deletion", this.getName()));
            JCloudsSlave node = (JCloudsSlave)this.getNode();
            if (null != node && !node.isPendingDelete()) {
                node.setPendingDelete(true);
            }
        }
    }

    public void deleteSlave(boolean logging) {
        block2: {
            try {
                this.deleteSlave();
            }
            catch (Exception e) {
                if (!logging) break block2;
                LOGGER.log(Level.WARNING, "Failed to delete agent", e);
            }
        }
    }

    private Set<String> getIpAddresses(boolean wantPublic) {
        JCloudsSlave node = (JCloudsSlave)this.getNode();
        if (null != node) {
            Set ret;
            NodeMetadata md = node.getNodeMetaData();
            Set set = ret = wantPublic ? md.getPublicAddresses() : md.getPrivateAddresses();
            if (!ret.isEmpty()) {
                return ret;
            }
        }
        return ImmutableSet.of((Object)"None");
    }

    private String MarkPreferredAddress(String txt, String pre, String post) {
        JCloudsSlave node = (JCloudsSlave)this.getNode();
        if (null != node) {
            NodeMetadata md = node.getNodeMetaData();
            String match = JCloudsLauncher.getConnectionAddress(md, null, node.getPreferredAddress());
            return txt.replace(match, pre + match + post);
        }
        return txt;
    }

    public String getPublicIpAddressHeader() {
        return "Public IP-Address" + (this.getIpAddresses(true).size() > 1 ? "es" : "");
    }

    public String getPrivateIpAddressHeader() {
        return "Private IP-Address" + (this.getIpAddresses(false).size() > 1 ? "es" : "");
    }

    public String getPublicIpAddresses() {
        return this.MarkPreferredAddress(String.join((CharSequence)" ", this.getIpAddresses(true)), "<b>", "</b>");
    }

    public String getPrivateIpAddresses() {
        return this.MarkPreferredAddress(String.join((CharSequence)" ", this.getIpAddresses(false)), "<b>", "</b>");
    }

    @Nullable
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }
}

