/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.RelativePath;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.ComboBoxModel;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import hudson.util.XStream2;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliMessages;
import jenkins.plugins.jclouds.compute.ComputeLogger;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import jenkins.plugins.jclouds.compute.MetaDataPublisher;
import jenkins.plugins.jclouds.compute.PhoneHomeMonitor;
import jenkins.plugins.jclouds.compute.internal.RunningNode;
import jenkins.plugins.jclouds.internal.CredentialsHelper;
import jenkins.plugins.jclouds.internal.LocationHelper;
import jenkins.plugins.jclouds.internal.SSHPublicKeyExtractor;
import jenkins.plugins.jclouds.modules.JenkinsConfigurationModule;
import net.sf.json.JSONObject;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.Apis;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.logging.jdk.config.JDKLoggingModule;
import org.jclouds.providers.Providers;
import org.jclouds.reflect.Reflection2;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedPlannedNode;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

public class JCloudsCloud
extends Cloud {
    static final Logger LOGGER = Logger.getLogger(JCloudsCloud.class.getName());
    @Deprecated
    private final transient String identity;
    @Deprecated
    private final transient Secret credential;
    public final String providerName;
    @Deprecated
    private final transient String privateKey;
    @Deprecated
    private final transient String publicKey;
    private transient AtomicInteger pendingNodes;
    public final String endPointUrl;
    public final String profile;
    private final int retentionTime;
    private final int errorRetentionTime;
    public int instanceCap;
    private CopyOnWriteArrayList<JCloudsSlaveTemplate> templates;
    public final int scriptTimeout;
    public final int startTimeout;
    private transient ComputeService compute;
    public final String zones;
    private String cloudGlobalKeyId;
    private String cloudCredentialsId;
    private String groupPrefix;
    private final boolean trustAll;
    private transient List<PhoneHomeMonitor> phms;
    private static final Iterable<Module> MODULES = ImmutableSet.of((Object)new SshjSshClientModule(), (Object)new JDKLoggingModule(){

        public Logger.LoggerFactory createLoggerFactory() {
            return new ComputeLogger.Factory();
        }
    }, (Object)((Object)new JenkinsConfigurationModule()));
    private static final Set<String> CONFIRMED_GZIP_SUPPORTERS = ImmutableSet.of((Object)"aws-ec2", (Object)"openstack-nova", (Object)"openstack-nova-ec2");
    private static final ConcurrentMap<Run<?, ?>, List<RunningNode>> supplementalsToCheck = new ConcurrentHashMap();

    static List<String> getCloudNames() {
        ArrayList<String> cloudNames = new ArrayList<String>();
        for (Cloud c : Jenkins.get().clouds) {
            if (!JCloudsCloud.class.isInstance(c)) continue;
            cloudNames.add(c.name);
        }
        return cloudNames;
    }

    static JCloudsCloud getByName(String name) {
        return (JCloudsCloud)Jenkins.get().clouds.getByName(name);
    }

    public String getName() {
        return this.name;
    }

    public String getCloudCredentialsId() {
        return this.cloudCredentialsId;
    }

    public boolean getTrustAll() {
        return this.trustAll;
    }

    public void setCloudCredentialsId(String value) {
        this.cloudCredentialsId = value;
    }

    public String getCloudGlobalKeyId() {
        return this.cloudGlobalKeyId;
    }

    public void setCloudGlobalKeyId(String value) {
        this.cloudGlobalKeyId = value;
    }

    public String getGlobalPrivateKey() {
        return this.getPrivateKeyFromCredential(this.cloudGlobalKeyId);
    }

    public String getGlobalPublicKey() {
        return this.getPublicKeyFromCredential(this.cloudGlobalKeyId);
    }

    public String getGroupPrefix() {
        return this.groupPrefix;
    }

    String prependGroupPrefix(String name) {
        if (null == name) {
            return null;
        }
        String tmp = Util.fixEmptyAndTrim((String)this.groupPrefix);
        return tmp == null ? name : tmp + "-" + name;
    }

    private String removeGroupPrefix(String name) {
        if (null == name) {
            return null;
        }
        String tmp = Util.fixEmptyAndTrim((String)this.groupPrefix);
        if (null == tmp) {
            return name;
        }
        return name.startsWith(tmp = tmp.concat("-")) ? name.substring(tmp.length()) : name;
    }

    private String getPrivateKeyFromCredential(String id) {
        SSHUserPrivateKey supk;
        if (!JCloudsCloud.isNullOrEmpty(id) && null != (supk = (SSHUserPrivateKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(SSHUserPrivateKey.class, null, null), (CredentialsMatcher)CredentialsMatchers.withId((String)id)))) {
            return CredentialsHelper.getPrivateKey(supk);
        }
        return "";
    }

    private String getPublicKeyFromCredential(String id) {
        if (!JCloudsCloud.isNullOrEmpty(id)) {
            try {
                return SSHPublicKeyExtractor.extract(this.getPrivateKeyFromCredential(id), null);
            }
            catch (IOException e) {
                LOGGER.warning(String.format("Error while extracting public key: %s", e));
            }
        }
        return "";
    }

    private FormValidation validateComputeContextParameters(String provider, String credId) {
        if (JCloudsCloud.isNullOrEmpty(credId)) {
            return FormValidation.error((String)"No cloud credentials specified.");
        }
        if (JCloudsCloud.isNullOrEmpty(provider)) {
            return FormValidation.error((String)"Provider Name shouldn't be empty");
        }
        return null;
    }

    boolean isUserDataSupported() {
        if ("google-compute-engine".equals(this.providerName)) {
            return true;
        }
        if ("digitalocean2".equals(this.providerName)) {
            return true;
        }
        try (ComputeServiceContext ctx = JCloudsCloud.ctx(this.providerName, this.cloudCredentialsId, this.endPointUrl, this.zones, this.trustAll);){
            TemplateOptions o = ctx.getComputeService().templateOptions();
            o.getClass().getMethod("userData", new byte[0].getClass());
        }
        catch (ReflectiveOperationException x) {
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FormValidation validateLocationId(String locationId) {
        if (JCloudsCloud.isNullOrEmpty(this.cloudCredentialsId)) {
            return FormValidation.error((String)"No cloud credentials provided.");
        }
        if (JCloudsCloud.isNullOrEmpty(this.providerName)) {
            return FormValidation.error((String)"Provider Name shouldn't be empty");
        }
        if (JCloudsCloud.isNullOrEmpty(locationId)) {
            return FormValidation.ok((String)"No location configured. jclouds automatically will choose one.");
        }
        locationId = Util.fixEmptyAndTrim((String)locationId);
        FormValidation result = FormValidation.error((String)"Invalid Location Id, please check the value and try again.");
        try (ComputeServiceContext ctx = JCloudsCloud.ctx(this.providerName, this.cloudCredentialsId, this.endPointUrl, this.zones, this.trustAll);){
            Location location;
            Set locations = ctx.getComputeService().listAssignableLocations();
            Iterator iterator = locations.iterator();
            do {
                if (!iterator.hasNext()) return result;
                location = (Location)iterator.next();
                if (!location.getId().equals(locationId)) continue;
                FormValidation formValidation = FormValidation.ok((String)"Location Id is valid.");
                return formValidation;
            } while (!location.getId().contains(locationId));
            FormValidation formValidation = FormValidation.warning((String)("Sorry cannot find the location id, Did you mean: " + location.getId() + "?\n" + String.valueOf(location)));
            return formValidation;
        }
        catch (Exception ex) {
            return FormValidation.error((String)"Unable to check the location id, please check if the credentials you provided are correct.", (Object[])new Object[]{ex});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FormValidation validateImageId(String imageId) {
        FormValidation res = this.validateComputeContextParameters(this.providerName, this.cloudCredentialsId);
        if (null != res) {
            return res;
        }
        if (JCloudsCloud.isNullOrEmpty(imageId)) {
            return FormValidation.error((String)"Image Id shouldn't be empty");
        }
        imageId = Util.fixEmptyAndTrim((String)imageId);
        try (ComputeServiceContext ctx = JCloudsCloud.ctx(this.providerName, this.cloudCredentialsId, this.endPointUrl, this.zones, this.trustAll);){
            Image image;
            Set images = ctx.getComputeService().listImages();
            if (images == null) return FormValidation.error((String)"Invalid Image Id, please check the value and try again.");
            Iterator iterator = images.iterator();
            do {
                if (!iterator.hasNext()) return FormValidation.error((String)"Invalid Image Id, please check the value and try again.");
                image = (Image)iterator.next();
                if (!image.getId().equals(imageId)) continue;
                FormValidation formValidation = FormValidation.ok((String)"Image Id is valid.");
                return formValidation;
            } while (!image.getId().contains(imageId));
            FormValidation formValidation = FormValidation.warning((String)("Sorry cannot find the image id, Did you mean: " + image.getId() + "?\n" + String.valueOf(image)));
            return formValidation;
        }
        catch (Exception ex) {
            return FormValidation.error((String)"Unable to check the image id, please check if the clouds credentials.", (Object[])new Object[]{ex});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FormValidation validateHardwareId(String hardwareId) {
        if (JCloudsCloud.isNullOrEmpty(this.cloudCredentialsId)) {
            return FormValidation.error((String)"No cloud credentials provided.");
        }
        if (JCloudsCloud.isNullOrEmpty(this.providerName)) {
            return FormValidation.error((String)"Provider Name should not be empty");
        }
        if (null == (hardwareId = Util.fixEmptyAndTrim((String)hardwareId))) {
            return FormValidation.error((String)"Hardware Id should not be empty");
        }
        FormValidation result = FormValidation.error((String)"Invalid Hardware Id, please check the value and try again.");
        try (ComputeServiceContext ctx = JCloudsCloud.ctx(this.providerName, this.cloudCredentialsId, this.endPointUrl, this.zones, this.trustAll);){
            Hardware hardware;
            Set hardwareProfiles = ctx.getComputeService().listHardwareProfiles();
            Iterator iterator = hardwareProfiles.iterator();
            do {
                if (!iterator.hasNext()) return result;
                hardware = (Hardware)iterator.next();
                if (!hardware.getId().equals(hardwareId)) continue;
                FormValidation formValidation = FormValidation.ok((String)"Hardware Id is valid.");
                return formValidation;
            } while (!hardware.getId().contains(hardwareId));
            FormValidation formValidation = FormValidation.warning((String)("Sorry cannot find the hardware id, Did you mean: " + hardware.getId() + "?\n" + String.valueOf(hardware)));
            return formValidation;
        }
        catch (Exception ex) {
            return FormValidation.error((String)"Unable to check the hardware id, please check if the clouds credentials.", (Object[])new Object[]{ex});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FormValidation validateImageNameRegex(String imageNameRegex) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FormValidation res = this.validateComputeContextParameters(this.providerName, this.cloudCredentialsId);
        if (null != res) {
            return res;
        }
        if (JCloudsCloud.isNullOrEmpty(imageNameRegex = Util.fixEmptyAndTrim((String)imageNameRegex))) {
            return FormValidation.error((String)"Image Name Regex should not be empty.");
        }
        try (ComputeServiceContext ctx = JCloudsCloud.ctx(this.providerName, this.cloudCredentialsId, this.endPointUrl, this.zones, this.trustAll);){
            FormValidation formValidation;
            int matchcount = 0;
            Pattern p = Pattern.compile(imageNameRegex);
            try {
                Set images = ctx.getComputeService().listImages();
                if (images == null) {
                    FormValidation formValidation2 = FormValidation.ok((String)"No images available to check against.");
                    return formValidation2;
                }
                for (Image image : images) {
                    if (!p.matcher(image.getName()).matches()) continue;
                    ++matchcount;
                }
            }
            catch (Exception ex) {
                FormValidation formValidation3 = FormValidation.error((String)"Unable to check the image name regex, please check if the credentials you provided are correct.", (Object[])new Object[]{ex});
                return formValidation3;
            }
            if (1 == matchcount) {
                formValidation = FormValidation.ok((String)"Image name regex matches exactly one image.");
                return formValidation;
            }
            if (1 >= matchcount) return FormValidation.error((String)"Image name regex does not match any image, please check the value and try again.");
            formValidation = FormValidation.error((String)"Ambiguous image name regex matches multiple images, please check the value and try again.");
            return formValidation;
        }
        catch (PatternSyntaxException ex) {
            return FormValidation.error((String)"Invalid image name regex syntax.");
        }
    }

    void fillHardwareIdItems(ListBoxModel m) {
        try (ComputeServiceContext ctx = JCloudsCloud.ctx(this.providerName, this.cloudCredentialsId, this.endPointUrl, this.zones, this.trustAll);){
            ArrayList hws = new ArrayList(ctx.getComputeService().listHardwareProfiles());
            Collections.sort(hws);
            for (Hardware hardware : hws) {
                m.add(String.format("%s (%s)", hardware.getId(), hardware.getName()), hardware.getId());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    void fillLocationIdItems(ListBoxModel m) {
        try (ComputeServiceContext ctx = JCloudsCloud.ctx(this.providerName, this.cloudCredentialsId, this.endPointUrl, this.zones, this.trustAll);){
            LocationHelper.fillLocations(m, ctx.getComputeService().listAssignableLocations());
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private synchronized void initPendingNodes() {
        if (null == this.pendingNodes) {
            this.pendingNodes = new AtomicInteger(0);
        }
    }

    @DataBoundConstructor
    public JCloudsCloud(String profile, String providerName, String cloudCredentialsId, String cloudGlobalKeyId, String endPointUrl, int instanceCap, int retentionTime, int errorRetentionTime, int scriptTimeout, int startTimeout, String zones, String groupPrefix, boolean trustAll, List<JCloudsSlaveTemplate> templates) {
        super(Util.fixEmptyAndTrim((String)profile));
        this.profile = Util.fixEmptyAndTrim((String)profile);
        this.providerName = Util.fixEmptyAndTrim((String)providerName);
        this.identity = null;
        this.credential = null;
        this.privateKey = null;
        this.publicKey = null;
        this.cloudGlobalKeyId = Util.fixEmptyAndTrim((String)cloudGlobalKeyId);
        this.cloudCredentialsId = Util.fixEmptyAndTrim((String)cloudCredentialsId);
        this.endPointUrl = Util.fixEmptyAndTrim((String)endPointUrl);
        this.instanceCap = instanceCap;
        this.retentionTime = retentionTime;
        this.errorRetentionTime = errorRetentionTime;
        this.scriptTimeout = scriptTimeout;
        this.startTimeout = startTimeout;
        this.templates = null != templates ? new CopyOnWriteArrayList<JCloudsSlaveTemplate>(templates) : new CopyOnWriteArrayList();
        this.zones = Util.fixEmptyAndTrim((String)zones);
        this.trustAll = trustAll;
        this.groupPrefix = groupPrefix;
        this.readResolve();
        this.initPendingNodes();
    }

    protected Object readResolve() {
        for (JCloudsSlaveTemplate tpl : this.templates) {
            tpl.setCloud(this);
        }
        return this;
    }

    public void addTemplate(JCloudsSlaveTemplate tpl) {
        tpl.setCloud(this);
        this.templates.add(tpl);
    }

    public void removeTemplate(JCloudsSlaveTemplate tpl) {
        this.templates.remove((Object)tpl);
    }

    public void replaceTemplate(JCloudsSlaveTemplate from, JCloudsSlaveTemplate to) {
        to.setCloud(this);
        this.templates.replaceAll(t -> ((Object)t).equals((Object)from) ? to : t);
    }

    public int getRetentionTime() {
        return this.retentionTime == 0 ? 30 : this.retentionTime;
    }

    public int getErrorRetentionTime() {
        return this.errorRetentionTime;
    }

    private static <A extends Closeable> A api(Class<A> apitype, String provider, String credId, Properties overrides) {
        Thread.currentThread().setContextClassLoader(Apis.class.getClassLoader());
        CredentialsHelper.setProject(credId, overrides);
        return (A)CredentialsHelper.setCredentials(ContextBuilder.newBuilder((String)provider), credId).overrides(overrides).modules(MODULES).buildApi(Reflection2.typeToken(apitype));
    }

    private static Properties buildJcloudsOverrides(String url, String zones, boolean trustAll) {
        Properties ret = new Properties();
        if (!JCloudsCloud.isNullOrEmpty(url)) {
            ret.setProperty("jclouds.endpoint", url);
        }
        if (trustAll) {
            ret.put("jclouds.trust-all-certs", "true");
            ret.put("jclouds.relax-hostname", "true");
        }
        if (!JCloudsCloud.isNullOrEmpty(zones)) {
            ret.setProperty("jclouds.zones", zones);
        }
        return ret;
    }

    static <A extends Closeable> A api(Class<A> apitype, String provider, String credId, String url, String zones) {
        return JCloudsCloud.api(apitype, provider, credId, JCloudsCloud.buildJcloudsOverrides(url, zones, false));
    }

    static <A extends Closeable> A api(Class<A> apitype, String provider, String credId, String url, String zones, boolean trustAll) {
        return JCloudsCloud.api(apitype, provider, credId, JCloudsCloud.buildJcloudsOverrides(url, zones, trustAll));
    }

    public <A extends Closeable> A newApi(Class<A> apitype) {
        Properties overrides = JCloudsCloud.buildJcloudsOverrides(this.endPointUrl, this.zones, this.trustAll);
        if (this.scriptTimeout > 0) {
            overrides.setProperty("jclouds.compute.timeout.script-complete", String.valueOf(this.scriptTimeout));
        }
        if (this.startTimeout > 0) {
            overrides.setProperty("jclouds.compute.timeout.node-running", String.valueOf(this.startTimeout));
        }
        return JCloudsCloud.api(apitype, this.providerName, this.cloudCredentialsId, overrides);
    }

    private static ComputeServiceContext ctx(String provider, String credId, Properties overrides) {
        Thread.currentThread().setContextClassLoader(Apis.class.getClassLoader());
        CredentialsHelper.setProject(credId, overrides);
        return (ComputeServiceContext)CredentialsHelper.setCredentials(ContextBuilder.newBuilder((String)provider), credId).overrides(overrides).modules(MODULES).buildView(ComputeServiceContext.class);
    }

    static ComputeServiceContext ctx(String provider, String credId, String url, String zones) {
        return JCloudsCloud.ctx(provider, credId, JCloudsCloud.buildJcloudsOverrides(url, zones, false));
    }

    static ComputeServiceContext ctx(String provider, String credId, String url, String zones, boolean trustAll) {
        return JCloudsCloud.ctx(provider, credId, JCloudsCloud.buildJcloudsOverrides(url, zones, trustAll));
    }

    public ComputeService newCompute() {
        Properties overrides = JCloudsCloud.buildJcloudsOverrides(this.endPointUrl, this.zones, this.trustAll);
        if (this.scriptTimeout > 0) {
            overrides.setProperty("jclouds.compute.timeout.script-complete", String.valueOf(this.scriptTimeout));
        }
        if (this.startTimeout > 0) {
            overrides.setProperty("jclouds.compute.timeout.node-running", String.valueOf(this.startTimeout));
        }
        return JCloudsCloud.ctx(this.providerName, this.cloudCredentialsId, overrides).getComputeService();
    }

    public ComputeService getCompute() {
        if (this.compute == null) {
            this.compute = this.newCompute();
        }
        return this.compute;
    }

    public List<JCloudsSlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public void setTemplates(List<JCloudsSlaveTemplate> newTemplates) {
        if (null != newTemplates) {
            for (JCloudsSlaveTemplate t : newTemplates) {
                t.setCloud(this);
            }
            this.templates = new CopyOnWriteArrayList<JCloudsSlaveTemplate>(newTemplates);
        } else {
            this.templates = new CopyOnWriteArrayList();
        }
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Cloud.CloudState state, int excessWorkload) {
        Label label = state.getLabel();
        final JCloudsSlaveTemplate tpl = this.getTemplate(label);
        ArrayList<NodeProvisioner.PlannedNode> plannedNodeList = new ArrayList<NodeProvisioner.PlannedNode>();
        while (excessWorkload > 0 && !Jenkins.get().isQuietingDown() && !Jenkins.get().isTerminating()) {
            this.initPendingNodes();
            if (this.getRunningNodesCount() + plannedNodeList.size() + this.pendingNodes.intValue() >= this.instanceCap) {
                LOGGER.info(String.format("Instance cap of %s reached while adding capacity for label %s", this.getName(), label != null ? label.toString() : "null"));
                break;
            }
            final ProvisioningActivity.Id provisioningId = new ProvisioningActivity.Id(this.name, tpl.name);
            plannedNodeList.add((NodeProvisioner.PlannedNode)new TrackedPlannedNode(provisioningId, tpl.getNumExecutors(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                @Override
                public Node call() throws Exception {
                    JCloudsSlave jcloudsSlave;
                    JCloudsCloud.this.pendingNodes.incrementAndGet();
                    try {
                        jcloudsSlave = tpl.provisionSlave((TaskListener)StreamTaskListener.fromStdout(), provisioningId);
                    }
                    finally {
                        JCloudsCloud.this.pendingNodes.decrementAndGet();
                    }
                    Jenkins.get().addNode((Node)jcloudsSlave);
                    JCloudsCloud.this.ensureLaunched(jcloudsSlave);
                    return jcloudsSlave;
                }
            })));
            excessWorkload -= tpl.getNumExecutors();
        }
        return plannedNodeList;
    }

    private void ensureLaunched(JCloudsSlave jcloudsSlave) throws InterruptedException, ExecutionException {
        jcloudsSlave.waitForPhoneHome(null);
        Integer launchTimeoutSec = 300;
        Computer computer = jcloudsSlave.toComputer();
        long startMoment = System.currentTimeMillis();
        while (null != computer && computer.isOffline() && !computer.getOfflineCauseReason().equals(CliMessages.ONE_OFF_CAUSE.getText())) {
            try {
                LOGGER.info(String.format("Agent %s not connected yet", jcloudsSlave.getDisplayName()));
                computer.connect(false).get();
                Thread.sleep(5000L);
            }
            catch (InterruptedException | ExecutionException e) {
                String msg = e.getMessage();
                if (null != msg && msg.contains("NULL agent")) {
                    throw new ExecutionException(new Throwable(msg));
                }
                LOGGER.warning(String.format("Error while launching %s: %s", jcloudsSlave.getDisplayName(), e));
            }
            if (System.currentTimeMillis() - startMoment <= 1000L * (long)launchTimeoutSec.intValue()) continue;
            String msg = String.format("Failed to connect to %s within %d sec.", jcloudsSlave.getDisplayName(), launchTimeoutSec);
            LOGGER.warning(msg);
            throw new ExecutionException(new Throwable(msg));
        }
    }

    public boolean canProvision(Cloud.CloudState state) {
        return this.getTemplate(state.getLabel()) != null;
    }

    public JCloudsSlaveTemplate getTemplate(String name) {
        for (JCloudsSlaveTemplate t : this.templates) {
            if (!t.name.equals(name)) continue;
            return t;
        }
        return null;
    }

    JCloudsSlaveTemplate getTemplate(Label label) {
        for (JCloudsSlaveTemplate t : this.templates) {
            if (label != null && !label.matches(t.getLabelSet())) continue;
            return t;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public JCloudsSlaveTemplate.DescriptorImpl getTemplateDescriptor() {
        return (JCloudsSlaveTemplate.DescriptorImpl)Jenkins.get().getDescriptorOrDie(JCloudsSlaveTemplate.class);
    }

    private String checkNewTemplateName(String name) {
        String ret = Util.fixEmptyAndTrim((String)name);
        if (null == ret) {
            throw new Failure("New template name must not be empty");
        }
        if (null != this.getTemplate(ret)) {
            throw new Failure("A template named " + ret + " already exists");
        }
        return ret;
    }

    @POST
    public void doReorder(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        String[] names = req.getParameterValues("name");
        if (names == null) {
            throw new Failure("No template names given");
        }
        List<String> namesList = Arrays.asList(names);
        ArrayList<JCloudsSlaveTemplate> ntpls = new ArrayList<JCloudsSlaveTemplate>(this.templates);
        ntpls.sort(Comparator.comparingInt(tpl -> JCloudsCloud.getIndexOf(namesList, tpl)));
        this.setTemplates(ntpls);
        j.save();
        rsp.sendRedirect2("templates");
    }

    private static int getIndexOf(List<String> namesList, JCloudsSlaveTemplate tpl) {
        int i = namesList.indexOf(tpl.name);
        return i == -1 ? Integer.MAX_VALUE : i;
    }

    @POST
    public synchronized void doCreate(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String name, @QueryParameter String mode, @QueryParameter String from) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (mode != null && mode.equals("on")) {
            name = this.checkNewTemplateName(name);
            if (null == (from = Util.fixEmptyAndTrim((String)from))) {
                throw new Failure("No source template was specified");
            }
            JCloudsSlaveTemplate fromTpl = this.getTemplate(from);
            String xml = Jenkins.XSTREAM.toXML((Object)fromTpl);
            xml = xml.replaceFirst("<name>.*</name>", "<name>" + name + "</name>");
            JCloudsSlaveTemplate tplTo = (JCloudsSlaveTemplate)((Object)Jenkins.XSTREAM.fromXML(xml));
            this.addTemplate(tplTo);
            rsp.sendRedirect2(Functions.getNearestAncestorUrl((StaplerRequest2)req, (Object)((Object)this)) + "/" + tplTo.getUrl());
        } else {
            this.handleNewSlaveTemplatePage(name, req, rsp);
        }
    }

    @POST
    public HttpResponse doDoCreate(StaplerRequest2 req) throws Descriptor.FormException, IOException, ServletException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        JCloudsSlaveTemplate tpl = (JCloudsSlaveTemplate)this.getTemplateDescriptor().newInstance(req, req.getSubmittedForm());
        if (null == Util.fixEmptyAndTrim((String)tpl.name)) {
            throw new Descriptor.FormException("Template name is mandatory", "templateName");
        }
        if (null != this.getTemplate(tpl.name)) {
            throw new Descriptor.FormException("Agent template name must be unique", "templateName");
        }
        this.addTemplate(tpl);
        j.save();
        return FormApply.success((String)"templates");
    }

    private void handleNewSlaveTemplatePage(String name, StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        name = this.checkNewTemplateName(name);
        JSONObject formData = req.getSubmittedForm();
        formData.put("name", (Object)name);
        formData.remove("mode");
        req.setAttribute("instance", (Object)formData);
        req.getView((Object)this, "_new.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public Cloud reconfigure(@NonNull StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        JCloudsCloud newInstance = (JCloudsCloud)super.reconfigure(req, form);
        newInstance.setTemplates(this.templates);
        return newInstance;
    }

    public JCloudsSlave doProvisionFromTemplate(JCloudsSlaveTemplate t) throws IOException {
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        ProvisioningActivity.Id provisioningId = new ProvisioningActivity.Id(this.name, t.name);
        JCloudsSlave node = t.provisionSlave((TaskListener)listener, provisioningId);
        Jenkins.get().addNode((Node)node);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public void doProvision(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String tplname) throws ServletException, IOException, Descriptor.FormException {
        this.checkPermission(PROVISION);
        if (tplname == null) {
            this.sendError("The agent template name query parameter is missing", req, rsp);
            return;
        }
        JCloudsSlaveTemplate t = this.getTemplate(tplname);
        if (t == null) {
            this.sendError("No such agent template with name : " + tplname, req, rsp);
            return;
        }
        this.initPendingNodes();
        if (this.getRunningNodesCount() + this.pendingNodes.intValue() < this.instanceCap) {
            try {
                this.pendingNodes.incrementAndGet();
                JCloudsSlave node = this.doProvisionFromTemplate(t);
                rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
            }
            finally {
                this.pendingNodes.decrementAndGet();
            }
        } else {
            this.sendError(String.format("Instance cap of %s reached", this.getName()), req, rsp);
        }
    }

    public int getRunningNodesCount() {
        int nodeCount = 0;
        for (ComputeMetadata cm : this.getCompute().listNodes()) {
            NodeMetadata nm;
            String nodeGroup;
            if (!NodeMetadata.class.isInstance(cm) || this.getTemplate(nodeGroup = this.removeGroupPrefix((nm = (NodeMetadata)cm).getGroup())) == null || ((NodeMetadata.Status)nm.getStatus()).equals((Object)NodeMetadata.Status.SUSPENDED) || ((NodeMetadata.Status)nm.getStatus()).equals((Object)NodeMetadata.Status.TERMINATED)) continue;
            ++nodeCount;
        }
        return nodeCount;
    }

    void registerPhoneHomeMonitor(PhoneHomeMonitor monitor) {
        if (null == monitor) {
            throw new IllegalArgumentException("monitor may not be null");
        }
        if (null == this.phms) {
            this.phms = new CopyOnWriteArrayList<PhoneHomeMonitor>();
        }
        this.phms.add(monitor);
    }

    public void unregisterPhoneHomeMonitor(PhoneHomeMonitor monitor) {
        if (null == monitor) {
            throw new IllegalArgumentException("monitor may not be null");
        }
        if (null != this.phms) {
            this.phms.remove(monitor);
        }
    }

    public boolean phoneHomeNotify(String name) {
        if (null != this.phms) {
            for (PhoneHomeMonitor monitor : this.phms) {
                if (!monitor.ring(name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean allowGzippedUserData() {
        return !JCloudsCloud.isNullOrEmpty(this.providerName) && CONFIRMED_GZIP_SUPPORTERS.contains(this.providerName);
    }

    static void cleanupSupplementalNodes() {
        for (Map.Entry entry : supplementalsToCheck.entrySet()) {
            Result result = ((Run)entry.getKey()).getResult();
            if (null == result || result != Result.ABORTED) continue;
            LOGGER.info("job \"" + ((Run)entry.getKey()).getFullDisplayName() + "\"was aborted, cleaning up supplemental nodes");
            for (final RunningNode rn : (List)entry.getValue()) {
                JCloudsCloud c = JCloudsCloud.getByName(rn.getCloudName());
                if (null == c) continue;
                if (rn.getShouldSuspend()) {
                    try {
                        LOGGER.info("Suspending supplemental node: " + rn.getNodeName());
                        c.getCompute().suspendNodesMatching((Predicate)new Predicate<NodeMetadata>(){

                            public boolean apply(NodeMetadata input) {
                                return null != input && input.getId().equals(rn.getNodeId());
                            }
                        });
                        continue;
                    }
                    catch (UnsupportedOperationException e) {
                        LOGGER.warning("Suspend unsupported on cloud: " + c.name);
                    }
                }
                LOGGER.info("Destroying supplemental node: " + rn.getNodeName());
                c.getCompute().destroyNodesMatching((Predicate)new Predicate<NodeMetadata>(){

                    public boolean apply(NodeMetadata input) {
                        return null != input && input.getId().equals(rn.getNodeId());
                    }
                });
            }
            supplementalsToCheck.remove(entry.getKey());
        }
    }

    static synchronized void publishMetadata(Iterable<RunningNode> nodes, Map<String, String> data, String indexName) {
        int idx = 0;
        for (RunningNode rn : nodes) {
            String nid = rn.getNodeId();
            String msg = "Publishing metadata to supplemental node " + nid;
            if (!indexName.isEmpty()) {
                data.put(indexName, String.valueOf(idx++));
            }
            MetaDataPublisher mdp = new MetaDataPublisher(JCloudsCloud.getByName(rn.getCloudName()));
            mdp.publish(nid, msg, data);
        }
    }

    static synchronized void registerSupplementalCleanup(Run<?, ?> build, Iterable<RunningNode> nodes) {
        LOGGER.fine("Registering build \"" + build.getFullDisplayName() + "\" for cleanup");
        ArrayList<RunningNode> newList = new ArrayList<RunningNode>();
        for (RunningNode rn : nodes) {
            newList.add(rn);
        }
        if (!newList.isEmpty()) {
            List oldList = supplementalsToCheck.getOrDefault(build, new ArrayList());
            oldList.addAll(newList);
            supplementalsToCheck.put(build, oldList);
        }
    }

    static void unregisterSupplementalCleanup(Run<?, ?> build) {
        LOGGER.fine("Unregistering build \"" + build.getFullDisplayName() + "\" from cleanup");
        supplementalsToCheck.remove(build);
    }

    static boolean isNullOrEmpty(String value) {
        return null == Util.fixEmptyAndTrim((String)value);
    }

    @Restricted(value={DoNotUse.class})
    public static class ConverterImpl
    extends XStream2.PassthruConverter<JCloudsCloud> {
        static final Logger LOGGER = Logger.getLogger(ConverterImpl.class.getName());

        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(JCloudsCloud c, UnmarshallingContext context) {
            boolean any = false;
            if (JCloudsCloud.isNullOrEmpty(c.getCloudGlobalKeyId()) && !JCloudsCloud.isNullOrEmpty(c.privateKey)) {
                LOGGER.info("Upgrading config data: cloud global key -> via credentials plugin");
                c.setCloudGlobalKeyId(this.convertCloudPrivateKey(c.name, c.privateKey));
                any = true;
            }
            if (JCloudsCloud.isNullOrEmpty(c.getCloudCredentialsId()) && !JCloudsCloud.isNullOrEmpty(c.identity)) {
                LOGGER.info("Upgrading config data: cloud credentals -> via credentials plugin");
                String description = "JClouds cloud " + c.name + " - auto-migrated";
                c.setCloudCredentialsId(CredentialsHelper.convertCredentials(description, c.identity, c.credential));
                any = true;
            }
            for (JCloudsSlaveTemplate t : c.templates) {
                if (!t.upgrade()) continue;
                any = true;
            }
            if (any) {
                LOGGER.info(String.format(">>>>>> cloud %s needs saving migrated config data", c.name));
                DescriptorImpl cfr_ignored_0 = (DescriptorImpl)c.getDescriptor();
                DescriptorImpl.needSave = true;
            }
        }

        private String convertCloudPrivateKey(String name, String privateKey) {
            String description = "JClouds cloud " + name + " - auto-migrated";
            BasicSSHUserPrivateKey u = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, null, "Global key", (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey), null, description);
            try {
                return CredentialsHelper.storeCredentials((StandardUsernameCredentials)u);
            }
            catch (IOException e) {
                LOGGER.warning(String.format("Error while migrating privateKey: %s", e.getMessage()));
                return null;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        static boolean needSave = false;

        @NonNull
        public String getDisplayName() {
            return "Cloud (JClouds)";
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter String providerName, @QueryParameter String cloudCredentialsId, @QueryParameter String cloudGlobalKeyId, @QueryParameter String endPointUrl, @QueryParameter String zones, @QueryParameter boolean trustAll) throws IOException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (null == Util.fixEmptyAndTrim((String)cloudCredentialsId)) {
                return FormValidation.error((String)"Cloud credentials not specified.");
            }
            if (null == Util.fixEmptyAndTrim((String)cloudGlobalKeyId)) {
                return FormValidation.error((String)"Cloud RSA key is not specified.");
            }
            providerName = Util.fixEmptyAndTrim((String)providerName);
            endPointUrl = Util.fixEmptyAndTrim((String)endPointUrl);
            zones = Util.fixEmptyAndTrim((String)zones);
            FormValidation result = FormValidation.ok((String)"Connection succeeded!");
            try (ComputeServiceContext ctx = JCloudsCloud.ctx(providerName, cloudCredentialsId, endPointUrl, zones, trustAll);){
                ctx.getComputeService().listNodes();
            }
            catch (Exception ex) {
                result = FormValidation.error((String)("Cannot connect to specified cloud, please check the credentials: " + ex.getMessage()));
            }
            return result;
        }

        @POST
        public FormValidation doCheckCloudGlobalKeyId(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            FormValidation ret = FormValidation.validateRequired((String)value);
            if (ret.equals(FormValidation.ok())) {
                StandardUsernameCredentials suc = CredentialsHelper.getCredentialsById(value);
                if (null == suc) {
                    ret = FormValidation.error((String)"Credentials with id %s not found", (Object[])new Object[]{value});
                } else if (!CredentialsHelper.isRSACredential(value)) {
                    ret = FormValidation.error((String)"Not an RSA SSH key credential");
                }
            }
            return ret;
        }

        ImmutableSortedSet<String> getAllProviders() {
            Thread.currentThread().setContextClassLoader(Apis.class.getClassLoader());
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(Iterables.transform((Iterable)Apis.viewableAs(ComputeServiceContext.class), (Function)Apis.idFunction()));
            builder.addAll(Iterables.transform((Iterable)Providers.viewableAs(ComputeServiceContext.class), (Function)Providers.idFunction()));
            return ImmutableSortedSet.copyOf((Collection)builder.build());
        }

        public String defaultProviderName() {
            return (String)this.getAllProviders().first();
        }

        @POST
        public ListBoxModel doFillProviderNameItems() {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel m = new ListBoxModel();
            for (String supportedProvider : this.getAllProviders()) {
                if ("stub".equals(supportedProvider) || "docker".equals(supportedProvider)) continue;
                m.add(supportedProvider, supportedProvider);
            }
            return m;
        }

        @POST
        public ListBoxModel doFillCloudCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String currentValue) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.get()).hasPermission(Computer.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(currentValue);
            }
            return new StandardUsernameListBoxModel().includeAs(ACL.SYSTEM2, context, StandardUsernameCredentials.class).includeCurrentValue(currentValue);
        }

        @POST
        public ListBoxModel doFillCloudGlobalKeyIdItems(@AncestorInPath ItemGroup context, @QueryParameter String currentValue) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.get()).hasPermission(Computer.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(currentValue);
            }
            return new StandardUsernameListBoxModel().includeAs(ACL.SYSTEM2, context, SSHUserPrivateKey.class).includeCurrentValue(currentValue);
        }

        @POST
        public ComboBoxModel doFillCopyNewTemplateFromItems(@RelativePath(value="..") @QueryParameter String cloudName) {
            ComboBoxModel m = new ComboBoxModel();
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            if (null != c) {
                for (JCloudsSlaveTemplate tpl : c.getTemplates()) {
                    m.add((Object)tpl.name);
                }
            }
            return m;
        }

        @POST
        public FormValidation doCheckNewTemplateName(@QueryParameter String cloudName, @QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            JCloudsCloud c = JCloudsCloud.getByName(cloudName);
            if (null != c && null != c.getTemplate(value)) {
                return FormValidation.error((String)("A template named " + value + " already exists"));
            }
            return FormValidation.validateRequired((String)value);
        }

        @POST
        public FormValidation doCheckProfile(@QueryParameter String initialName, @QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                Jenkins.checkGoodName((String)value);
            }
            catch (Failure x) {
                return FormValidation.error((String)x.getMessage());
            }
            if (!initialName.equals(value) && null != Jenkins.get().clouds.getByName(value)) {
                return FormValidation.error((String)("A cloud named " + value + " already exists"));
            }
            return FormValidation.validateRequired((String)value);
        }

        @POST
        public FormValidation doCheckProviderName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        @POST
        public FormValidation doCheckInstanceCap(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        @POST
        public FormValidation doCheckRetentionTime(@QueryParameter String value) {
            int n;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                n = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Not a number");
            }
            if (n >= -1) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Number must be >= -1");
        }

        @POST
        public FormValidation doCheckScriptTimeout(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        @POST
        public FormValidation doCheckStartTimeout(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        @POST
        public FormValidation doCheckEndPointUrl(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (!(value.isEmpty() || value.startsWith("http://") || value.startsWith("https://"))) {
                return FormValidation.error((String)"The endpoint must be a http(s) URL");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckGroupPrefix(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (!value.matches("^[a-z0-9]*$")) {
                return FormValidation.error((String)"The group prefix may contain lowercase letters and numbers only.");
            }
            return FormValidation.ok();
        }

        @Initializer(after=InitMilestone.JOB_LOADED)
        public static void completed() throws IOException {
            if (needSave) {
                needSave = false;
                LOGGER.info(">>>>>> auto-saving migrated config data...");
                Jenkins.get().save();
            }
        }
    }
}

