/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Computer;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsComputer;
import jenkins.plugins.jclouds.compute.JCloudsSlave;

@Extension
public final class JCloudsCleanupThread
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(JCloudsCleanupThread.class.getName());

    public JCloudsCleanupThread() {
        super("JClouds slave cleanup");
    }

    public long getRecurrencePeriod() {
        return 300000L;
    }

    public static void invoke() {
        JCloudsCleanupThread.getInstance().run();
    }

    private static JCloudsCleanupThread getInstance() {
        return (JCloudsCleanupThread)((Object)Jenkins.get().getExtensionList(AsyncPeriodicWork.class).get(JCloudsCleanupThread.class));
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }

    protected void execute(TaskListener listener) {
        ImmutableList.Builder deletedNodesBuilder = ImmutableList.builder();
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Computer.threadPoolForRemoting);
        ImmutableList.Builder computersToDeleteBuilder = ImmutableList.builder();
        for (final Computer c : Jenkins.get().getComputers()) {
            JCloudsComputer comp;
            JCloudsSlave node;
            if (!JCloudsComputer.class.isInstance(c) || null == (node = (JCloudsSlave)(comp = (JCloudsComputer)c).getNode()) || !node.isPendingDelete()) continue;
            computersToDeleteBuilder.add((Object)comp);
            ListenableFuture f = executor.submit(new Runnable(){

                @Override
                public void run() {
                    LOGGER.log(Level.INFO, "Deleting pending node " + comp.getName());
                    try {
                        node.terminate();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to disconnect and delete " + c.getName() + ": " + e.getMessage());
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.WARNING, "Failed to disconnect and delete " + c.getName() + ": " + e.getMessage());
                    }
                }
            });
            deletedNodesBuilder.add((Object)f);
        }
        Futures.getUnchecked((Future)Futures.successfulAsList((Iterable)deletedNodesBuilder.build()));
        for (JCloudsComputer c : computersToDeleteBuilder.build()) {
            try {
                c.deleteSlave();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to disconnect and delete " + c.getName() + ": " + e.getMessage());
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "Failed to disconnect and delete " + c.getName() + ": " + e.getMessage());
            }
        }
        JCloudsCloud.cleanupSupplementalNodes();
    }
}

