/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Hudson;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.InstancesToRun;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import jenkins.plugins.jclouds.compute.PhoneHomeMonitor;
import jenkins.plugins.jclouds.compute.internal.NodePlan;
import jenkins.plugins.jclouds.compute.internal.ProvisionPlannedInstancesAndDestroyAllOnError;
import jenkins.plugins.jclouds.compute.internal.RunningNode;
import jenkins.plugins.jclouds.compute.internal.TerminateNodes;
import jenkins.plugins.jclouds.internal.TaskListenerLogger;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class JCloudsBuildWrapper
extends SimpleBuildWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_ENVVARNAME = "JCLOUDS_IPS";
    private static final String DEFAULT_INDEXNAME = "JCLOUDS_SUPPLEMENTAL_INDEX";
    private final List<InstancesToRun> instancesToRun;
    private String envVarName = null;
    private String publishMeta = null;
    private String indexName = null;

    @DataBoundConstructor
    public JCloudsBuildWrapper(List<InstancesToRun> instancesToRun) {
        this.instancesToRun = instancesToRun;
    }

    @DataBoundSetter
    public void setEnvVarName(String value) {
        this.envVarName = (String)Util.fixNull((Object)Util.fixEmptyAndTrim((String)value), (Object)DEFAULT_ENVVARNAME);
    }

    public String getEnvVarName() {
        return this.envVarName;
    }

    @DataBoundSetter
    public void setPublishMeta(String value) {
        this.publishMeta = Util.fixEmptyAndTrim((String)value);
    }

    public String getPublishMeta() {
        return this.publishMeta;
    }

    @DataBoundSetter
    public void setIndexName(String value) {
        this.indexName = (String)Util.fixNull((Object)Util.fixEmptyAndTrim((String)value), (Object)DEFAULT_INDEXNAME);
    }

    public String getIndexName() {
        return this.indexName;
    }

    private String getEnvVarNameWithDefault() {
        return (String)Util.fixNull((Object)this.envVarName, (Object)DEFAULT_ENVVARNAME);
    }

    private String getIndexNameWithDefault() {
        return (String)Util.fixNull((Object)this.indexName, (Object)DEFAULT_INDEXNAME);
    }

    public List<InstancesToRun> getInstancesToRun() {
        return this.instancesToRun;
    }

    public boolean requiresWorkspace() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, TaskListener listener, final EnvVars initialEnvironment) throws IOException, InterruptedException {
        for (InstancesToRun inst : this.instancesToRun) {
            String cn = inst.cloudName;
            Cloud c = Jenkins.get().clouds.getByName(cn);
            if (null == c) {
                throw new AbortException(String.format("A cloud named %s does not exist.", cn));
            }
            if (!JCloudsCloud.class.isInstance(c)) {
                throw new AbortException(String.format("The cloud named %s is not controlled by jclouds.", cn));
            }
            String tpln = initialEnvironment.expand(inst.getActualTemplateName());
            if (null != ((JCloudsCloud)c).getTemplate(tpln)) continue;
            throw new AbortException(String.format("The cloud named %s does not provide a template named %s.", cn, tpln));
        }
        String failedCloud = this.validateInstanceCaps();
        if (null != failedCloud) {
            throw new AbortException(String.format("Instance cap for cloud %s reached.", failedCloud));
        }
        Iterable nodePlans = Iterables.transform(this.instancesToRun, (Function)new Function<InstancesToRun, NodePlan>(){

            public NodePlan apply(InstancesToRun instance) {
                String cloudName = instance.cloudName;
                String templateName = initialEnvironment.expand(instance.getActualTemplateName());
                JCloudsSlaveTemplate nodeSupplier = JCloudsCloud.getByName(cloudName).getTemplate(templateName);
                return new NodePlan(cloudName, templateName, instance.count, instance.shouldSuspend, nodeSupplier);
            }
        });
        TaskListenerLogger logger = new TaskListenerLogger(listener);
        TerminateNodes terminateNodes = new TerminateNodes();
        ProvisionPlannedInstancesAndDestroyAllOnError provisioner = new ProvisionPlannedInstancesAndDestroyAllOnError(MoreExecutors.listeningDecorator((ExecutorService)Computer.threadPoolForRemoting), logger, terminateNodes);
        Iterable<RunningNode> runningNodes = provisioner.apply(nodePlans);
        if (Iterables.size(runningNodes) <= 0) {
            context.env(this.getEnvVarNameWithDefault(), " ");
            return;
        }
        JCloudsCloud.registerSupplementalCleanup(build, runningNodes);
        HashMap<String, String> metaData = new HashMap<String, String>();
        for (String k : Util.fixNull((String)this.publishMeta).split(" +")) {
            if (!initialEnvironment.containsKey((Object)k)) continue;
            String v = (String)initialEnvironment.get((Object)k);
            metaData.put(k, v);
        }
        JCloudsCloud.publishMetadata(runningNodes, metaData, this.getIndexNameWithDefault());
        HashSet<String> cloudsToPossiblyAbortWaiting = new HashSet<String>();
        try {
            ConcurrentMap<JCloudsCloud, List<PhoneHomeMonitor>> waitParams = this.waitPhoneHomeSetup(runningNodes, listener.getLogger());
            if (!waitParams.isEmpty()) {
                for (Map.Entry entry : waitParams.entrySet()) {
                    cloudsToPossiblyAbortWaiting.add(((JCloudsCloud)((Object)entry.getKey())).getName());
                    try {
                        for (PhoneHomeMonitor phm : (List)entry.getValue()) {
                            phm.join();
                            ((JCloudsCloud)((Object)entry.getKey())).unregisterPhoneHomeMonitor(phm);
                        }
                    }
                    catch (InterruptedException x) {
                        Iterator iterator = ((List)entry.getValue()).iterator();
                        while (iterator.hasNext()) {
                            PhoneHomeMonitor phm = (PhoneHomeMonitor)iterator.next();
                            phm.ring();
                        }
                        throw x;
                    }
                }
            }
        }
        catch (InterruptedException x) {
            throw new AbortException("Wait for phone-home aborted");
        }
        List<String> ips = this.getInstanceIPs(runningNodes, listener.getLogger());
        context.env(this.getEnvVarNameWithDefault(), ips.size() > 0 ? String.join((CharSequence)",", ips) : " ");
        context.setDisposer((SimpleBuildWrapper.Disposer)new JCloudsBuildWrapperDisposer(runningNodes, terminateNodes, cloudsToPossiblyAbortWaiting));
    }

    private boolean isBeyondInstanceCap(String cloudName, int numOfNewInstances) {
        Hudson.CloudList cl = Jenkins.get().clouds;
        Cloud c = cl.getByName(cloudName);
        if (null != c && c instanceof JCloudsCloud) {
            JCloudsCloud jc = (JCloudsCloud)c;
            return jc.getRunningNodesCount() + numOfNewInstances >= jc.instanceCap;
        }
        return false;
    }

    private String validateInstanceCaps() throws IOException {
        HashMap<String, Integer> startPerCloud = new HashMap<String, Integer>();
        for (InstancesToRun instancesToRun : this.instancesToRun) {
            Integer old = startPerCloud.put(instancesToRun.cloudName, instancesToRun.count);
            if (null == old) continue;
            startPerCloud.put(instancesToRun.cloudName, old + Integer.valueOf(instancesToRun.count));
        }
        for (Map.Entry entry : startPerCloud.entrySet()) {
            String cname = (String)entry.getKey();
            if (!this.isBeyondInstanceCap(cname, (Integer)entry.getValue())) continue;
            return cname;
        }
        return null;
    }

    private ConcurrentMap<JCloudsCloud, List<PhoneHomeMonitor>> waitPhoneHomeSetup(Iterable<RunningNode> runningNodes, PrintStream logger) {
        ConcurrentHashMap<JCloudsCloud, List<PhoneHomeMonitor>> ret = new ConcurrentHashMap<JCloudsCloud, List<PhoneHomeMonitor>>();
        ConcurrentHashMap<JCloudsCloud, ConcurrentMap> cloudWaitMap = new ConcurrentHashMap<JCloudsCloud, ConcurrentMap>();
        for (RunningNode runningNode : runningNodes) {
            JCloudsSlaveTemplate t;
            JCloudsCloud c = JCloudsCloud.getByName(runningNode.getCloudName());
            if (null == c || null == (t = c.getTemplate(runningNode.getTemplateName())) || !t.waitPhoneHome || t.waitPhoneHomeTimeout <= 0) continue;
            ConcurrentMap waitMap = cloudWaitMap.getOrDefault((Object)c, new ConcurrentHashMap());
            Integer wto = t.waitPhoneHomeTimeout;
            List hosts = waitMap.getOrDefault(wto, new ArrayList());
            hosts.add(runningNode.getNodeName());
            waitMap.put(wto, hosts);
            cloudWaitMap.put(c, waitMap);
        }
        for (Map.Entry entry : cloudWaitMap.entrySet()) {
            for (Map.Entry entry2 : ((ConcurrentMap)entry.getValue()).entrySet()) {
                PhoneHomeMonitor phm = new PhoneHomeMonitor(true, (Integer)entry2.getKey());
                phm.waitForPhoneHomeMultiple((List)entry2.getValue(), logger);
                ((JCloudsCloud)((Object)entry.getKey())).registerPhoneHomeMonitor(phm);
                List phmList = ret.getOrDefault(entry.getKey(), new ArrayList());
                phmList.add(phm);
                ret.put((JCloudsCloud)((Object)entry.getKey()), phmList);
            }
        }
        return ret;
    }

    private List<String> getInstanceIPs(Iterable<RunningNode> runningNodes, PrintStream logger) {
        ImmutableList.Builder ips = ImmutableList.builder();
        for (RunningNode rn : runningNodes) {
            String ip = rn.getNodeInstanceAddress(logger);
            if (null == ip) continue;
            ips.add((Object)ip);
        }
        return ips.build();
    }

    private static class JCloudsBuildWrapperDisposer
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 1L;
        private static final Logger LOGGER = Logger.getLogger(JCloudsBuildWrapperDisposer.class.getName());
        private final Iterable<RunningNode> runningNodes;
        private final TerminateNodes terminateNodes;
        private final Set<String> waitingClouds;

        JCloudsBuildWrapperDisposer(Iterable<RunningNode> runningNodes, TerminateNodes terminateNodes, Set<String> waitingClouds) {
            this.runningNodes = runningNodes;
            this.waitingClouds = waitingClouds;
            this.terminateNodes = terminateNodes;
        }

        public void tearDown(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
            LOGGER.info("Terminating supplemental nodes");
            listener.getLogger().println("Terminating supplemental nodes");
            for (String cloud : this.waitingClouds) {
                for (RunningNode rn : this.runningNodes) {
                    JCloudsCloud.getByName(cloud).phoneHomeNotify(rn.getHostName());
                }
            }
            this.terminateNodes.apply(this.runningNodes);
            JCloudsCloud.unregisterSupplementalCleanup(build);
        }
    }

    @Extension
    @Symbol(value={"withJclouds"})
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Create supplemental nodes";
        }

        public boolean isApplicable(AbstractProject item) {
            for (String name : JCloudsCloud.getCloudNames()) {
                JCloudsCloud c = JCloudsCloud.getByName(name);
                if (c == null || c.getTemplates().size() <= 0) continue;
                return true;
            }
            return false;
        }
    }
}

