/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.compute;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.security.Permission;
import hudson.slaves.Cloud;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public final class InstancesToRun
extends AbstractDescribableImpl<InstancesToRun>
implements Serializable {
    private static final long serialVersionUID = -1L;
    public final String cloudName;
    public final String templateName;
    public final String manualTemplateName;
    public final int count;
    public final boolean shouldSuspend;

    @DataBoundConstructor
    public InstancesToRun(String cloudName, String templateName, String manualTemplateName, int count, boolean shouldSuspend) {
        this.cloudName = Util.fixEmptyAndTrim((String)cloudName);
        this.templateName = Util.fixEmptyAndTrim((String)templateName);
        this.manualTemplateName = Util.fixEmptyAndTrim((String)manualTemplateName);
        this.count = count;
        this.shouldSuspend = shouldSuspend;
    }

    public String getActualTemplateName() {
        if (this.isUsingManualTemplateName()) {
            return this.manualTemplateName;
        }
        return this.templateName;
    }

    public boolean isUsingManualTemplateName() {
        return this.manualTemplateName != null && !this.manualTemplateName.equals("");
    }

    @Extension
    @Symbol(value={"instances"})
    public static class DescriptorImpl
    extends Descriptor<InstancesToRun> {
        public String defaultCloudName() {
            for (String name : JCloudsCloud.getCloudNames()) {
                JCloudsCloud c = JCloudsCloud.getByName(name);
                if (c == null || c.getTemplates().size() <= 0) continue;
                return name;
            }
            return "";
        }

        @POST
        public ListBoxModel doFillCloudNameItems(@AncestorInPath AbstractProject project) {
            if (null == project) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Permission.CONFIGURE);
            }
            Jenkins.get().checkPermission(Cloud.PROVISION);
            ListBoxModel m = new ListBoxModel();
            for (String name : JCloudsCloud.getCloudNames()) {
                JCloudsCloud c = JCloudsCloud.getByName(name);
                if (c == null || c.getTemplates().size() <= 0) continue;
                m.add(name, name);
            }
            return m;
        }

        @POST
        public ListBoxModel doFillTemplateNameItems(@AncestorInPath AbstractProject project, @QueryParameter(value="cloudName") String cname) {
            if (null == project) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Permission.CONFIGURE);
            }
            Jenkins.get().checkPermission(Cloud.PROVISION);
            ListBoxModel m = new ListBoxModel();
            JCloudsCloud c = JCloudsCloud.getByName(cname);
            if (c != null) {
                for (JCloudsSlaveTemplate t : c.getTemplates()) {
                    m.add(t.name, t.name);
                }
            }
            return m;
        }

        public FormValidation doCheckCount(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public String getDisplayName() {
            return "";
        }
    }
}

