/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

class Replacements {
    private final List<Replacement> replacements;

    Replacements() {
        this.replacements = new ArrayList<Replacement>();
    }

    Replacements(String xml) {
        XStream xstream = Jenkins.XSTREAM;
        xstream.processAnnotations(Replacement.class);
        xstream.alias("replacements", List.class);
        this.replacements = (List)xstream.fromXML(xml);
    }

    String toXML() {
        XStream xstream = Jenkins.XSTREAM;
        xstream.processAnnotations(Replacement.class);
        xstream.alias("replacements", List.class);
        return xstream.toXML(this.replacements);
    }

    void add(String from, String to) {
        this.replacements.add(new Replacement(from, to));
    }

    String replace(String xml) {
        for (Replacement r : this.replacements) {
            Pattern p = Pattern.compile(String.format("^(\\s*<\\w+) +sha256=\"[0-9a-fA-F]+\">%s(<.*)$", Pattern.quote(r.getFrom())), 8);
            xml = p.matcher(xml).replaceAll(String.format("$1>%s$2", Matcher.quoteReplacement(r.getTo()))).replace(r.getFrom(), r.getTo());
        }
        return xml;
    }

    @XStreamAlias(value="replacement")
    static class Replacement {
        @XStreamAsAttribute
        private String from;
        @XStreamAsAttribute
        private String to;

        public Replacement(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }
    }
}

