/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import com.thoughtworks.xstream.XStreamException;
import hudson.Extension;
import hudson.cli.CLICommand;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class JCloudsUpdateTemplateCommand
extends CLICommand {
    @Argument(required=false, metaVar="PROFILE", index=1, usage="Name of jclouds profile to use. Reqired, if TEMPLATE is ambiguous.")
    public String profile = null;
    @Argument(metaVar="TEMPLATE", usage="Name of the existing template to update.", required=true)
    public String name;
    @Option(required=false, name="-v", aliases={"--verbose"}, usage="Be verbose when validating references to credentials and config files.")
    private boolean verbose;

    public String getShortDescription() {
        return Messages.UpdateTemplateCommand_shortDescription();
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JCloudsCloud c = CliHelper.resolveCloud(this.profile, true);
        JCloudsSlaveTemplate otpl = CliHelper.resolveTemplate(c, this.name);
        String xml = new String(this.stdin.readAllBytes(), StandardCharsets.UTF_8);
        JCloudsSlaveTemplate ntpl = null;
        try {
            ntpl = (JCloudsSlaveTemplate)((Object)Jenkins.XSTREAM.fromXML(xml));
        }
        catch (XStreamException e) {
            throw new IllegalStateException("Unable to parse input: " + e.toString());
        }
        if (!ntpl.name.equals(this.name) && null != c.getTemplate(ntpl.name)) {
            throw new IllegalStateException(String.format("Unable to rename template: A template with the name %s already exists", ntpl.name));
        }
        CliHelper.validateTemplate(ntpl, xml, this.verbose ? this.stdout : CliHelper.getDevNull());
        c.replaceTemplate(otpl, ntpl);
        return 0;
    }
}

