/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import com.thoughtworks.xstream.XStreamException;
import hudson.Extension;
import hudson.cli.CLICommand;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class JCloudsUpdateCloudCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Name of the profile to update.", required=true)
    public String name;
    @Option(required=false, name="-v", aliases={"--verbose"}, usage="Be verbose when validating references to credentials.")
    private boolean verbose;
    @Option(required=false, name="-d", aliases={"--delete-templates"}, usage="Delete templates of target profile.")
    private boolean delete;
    @Option(required=false, name="-k", aliases={"--keep-templates"}, usage="Keep templates of target profile.")
    private boolean keep;

    public String getShortDescription() {
        return Messages.UpdateCloudCommand_shortDescription();
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JCloudsCloud oc = CliHelper.resolveCloud(this.name, false);
        if (null == oc) {
            throw new IllegalStateException("JClouds cloud profile '" + this.name + "' does not exist");
        }
        String xml = new String(this.stdin.readAllBytes(), StandardCharsets.UTF_8);
        JCloudsCloud nc = null;
        try {
            nc = (JCloudsCloud)((Object)Jenkins.XSTREAM.fromXML(xml));
        }
        catch (XStreamException e) {
            throw new IllegalStateException("Unable to parse input: " + e.toString());
        }
        if (!nc.name.equals(this.name) && null != Jenkins.get().clouds.getByName(nc.name)) {
            throw new IllegalStateException(String.format("Unable to rename cloud profile: A cloud with the name %s already exists", nc.name));
        }
        if (nc.getTemplates().size() == 0 && oc.getTemplates().size() > 0 && !this.keep && !this.delete) {
            throw new IllegalStateException("Unable to update " + this.name + ": Need --delete-templates or --keep-templates");
        }
        PrintStream devnull = CliHelper.getDevNull();
        CliHelper.validateCloudCredentials(nc, xml, this.verbose ? this.stdout : devnull);
        for (JCloudsSlaveTemplate tpl : nc.getTemplates()) {
            CliHelper.validateTemplate(tpl, xml, this.verbose ? this.stdout : devnull);
            tpl.setCloud(nc);
        }
        if (this.keep) {
            nc.setTemplates(oc.getTemplates());
        }
        Jenkins.get().clouds.replace((Object)oc, (Object)nc);
        return 0;
    }
}

