/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import hudson.Extension;
import hudson.Util;
import hudson.cli.CLICommand;
import hudson.model.Label;
import hudson.security.Permission;
import java.io.IOException;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import org.kohsuke.args4j.Option;

@Extension
public class JCloudsTemplatesCommand
extends CLICommand {
    static final String PROFILE = "Profile";
    static final String LABEL = "Label";
    static final String NAME = "Name";
    @Option(required=false, metaVar="EXPR", name="-l", aliases={"--labelmatch"}, usage="List templates that satisfy the specified label expression.")
    private String labelExpr;

    public String getShortDescription() {
        return Messages.TemplatesCommand_shortDescription();
    }

    protected int run() throws IOException {
        int maxProfileLen = 0;
        int maxTemplateLen = 0;
        int maxLabelLen = 0;
        this.labelExpr = Util.fixEmptyAndTrim((String)this.labelExpr);
        Label label = null == this.labelExpr ? null : Label.parseExpression((String)this.labelExpr);
        for (JCloudsCloud c : CliHelper.getAllJCloudClouds()) {
            if (!c.hasPermission(Permission.READ)) continue;
            if (c.profile.length() > maxProfileLen) {
                maxProfileLen = c.profile.length();
            }
            for (JCloudsSlaveTemplate t : c.getTemplates()) {
                if (label != null && !label.matches(t.getLabelSet())) continue;
                if (t.name.length() > maxTemplateLen) {
                    maxTemplateLen = t.name.length();
                }
                if (t.labelString.length() <= maxLabelLen) continue;
                maxLabelLen = t.labelString.length();
            }
        }
        if (maxTemplateLen > 0) {
            if (PROFILE.length() > maxProfileLen) {
                maxProfileLen = PROFILE.length();
            }
            if (NAME.length() > maxTemplateLen) {
                maxTemplateLen = NAME.length();
            }
            if (LABEL.length() > maxTemplateLen) {
                maxTemplateLen = LABEL.length();
            }
            String fmt = "%-" + maxProfileLen + "s %-" + maxTemplateLen + "s %-" + maxLabelLen + "s %s%n";
            this.stdout.printf(fmt, PROFILE, NAME, LABEL, "Description");
            this.stdout.println(String.format("%-" + (maxProfileLen + maxTemplateLen + maxLabelLen + 14) + "s", " ").replaceAll(" ", "="));
            String indent = String.format("%-" + (maxProfileLen + maxTemplateLen + maxLabelLen + 4) + "s", "\n");
            for (JCloudsCloud c : CliHelper.getAllJCloudClouds()) {
                for (JCloudsSlaveTemplate t : c.getTemplates()) {
                    if (label != null && !label.matches(t.getLabelSet())) continue;
                    this.stdout.printf(fmt, c.profile, t.name, t.labelString, t.description.replaceAll("\n", indent));
                }
            }
        }
        return 0;
    }
}

