/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.util.HashSet;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.CliMessages;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import org.jclouds.compute.domain.NodeMetadata;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Localizable;
import org.kohsuke.args4j.Option;

@Extension
public class JCloudsProvisionCommand
extends CLICommand {
    @Argument(required=false, metaVar="PROFILE", index=1, usage="Name of jclouds profile to use. Mandatory, if the TEMPLATE is ambiguous.")
    public String profile = null;
    @Argument(required=true, metaVar="TEMPLATE", index=0, usage="Name of template to use.")
    public String tmpl;
    @Option(required=false, name="-f", aliases={"--format"}, usage="Output format of provisioned agent properties.")
    public OutputFormat format = OutputFormat.HUMAN;

    public String getShortDescription() {
        return Messages.ProvisionCommand_shortDescription();
    }

    protected int run() throws IOException, CmdLineException {
        Jenkins.get().checkPermission(Jenkins.READ);
        JCloudsCloud c = CliHelper.resolveCloud(this.profile, true);
        JCloudsSlaveTemplate tpl = CliHelper.resolveTemplate(c, this.tmpl);
        if (null == c) {
            c = tpl.getCloud();
        }
        c.checkPermission(Cloud.PROVISION);
        if (c.getRunningNodesCount() < c.instanceCap) {
            JCloudsSlave s = c.doProvisionFromTemplate(tpl);
            NodeMetadata nmd = s.getNodeMetaData();
            HashSet a = new HashSet();
            a.addAll(nmd.getPrivateAddresses());
            a.addAll(nmd.getPublicAddresses());
            switch (this.format) {
                case HUMAN: {
                    String allAddrs = ((Object)a).toString().replaceAll("^\\[|\\]$", "");
                    this.stdout.println("Provisioned node " + s.getNodeName() + " with Address(es) " + allAddrs);
                    break;
                }
                case JSON: {
                    String allAddrs = ((Object)a).toString().replaceAll("^\\[|\\]$", "").replaceAll(", ", "\", \"");
                    this.stdout.println("{ \"name\": \"" + s.getNodeName() + "\", \"addr\": [\"" + allAddrs + "\"] }");
                    break;
                }
                case PROPERTIES: {
                    this.stdout.println("name=" + s.getNodeName());
                    for (String addr : a) {
                        this.stdout.println("addr=" + addr);
                    }
                    break;
                }
            }
        } else {
            throw new CmdLineException(null, (Localizable)CliMessages.INSTANCE_CAP_REACHED, new String[]{this.profile, this.tmpl});
        }
        return 0;
    }

    static enum OutputFormat {
        HUMAN,
        JSON,
        PROPERTIES;

    }
}

