/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.config.ConfigExport;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.OptionHandler;

@Extension
public class JCloudsGetUserdataCommand
extends CLICommand {
    @Option(hidden=true, name="--force", usage="Force unencrypted export.")
    private boolean force;
    @Argument(required=true, metaVar="CREDENTIAL", usage="ID of credential (Must be a RSA SSH credential) to encrypt data.")
    public String cred = null;

    public String getShortDescription() {
        return Messages.GetUserdataCommand_shortDescription();
    }

    protected int run() throws IOException, CmdLineException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ConfigExport ce = new ConfigExport(this.force ? null : this.cred);
        this.stdout.println("<?xml version='1.1' encoding='UTF-8'?>");
        this.stdout.println(ce.exportXml());
        return 0;
    }

    protected void printUsage(PrintStream stderr, CmdLineParser p) {
        stderr.print("java -jar jenkins-cli.jar " + this.getName());
        new UsageHelper(p).printSingleLineUsage(stderr);
        stderr.println();
        this.printUsageSummary(stderr);
        p.printUsage((OutputStream)stderr);
    }

    private static class UsageHelper {
        private final List<OptionHandler> options;
        private final List<OptionHandler> arguments;
        private final ParserProperties parserProperties;

        public UsageHelper(CmdLineParser p) {
            this.options = p.getOptions();
            this.arguments = p.getArguments();
            this.parserProperties = p.getProperties();
        }

        public void printSingleLineUsage(PrintStream stderr) {
            for (OptionHandler h : this.arguments) {
                this.printSingleLineOption(stderr, h);
            }
            for (OptionHandler h : this.options) {
                this.printSingleLineOption(stderr, h);
            }
            stderr.flush();
        }

        private void printSingleLineOption(PrintStream out, OptionHandler h) {
            if (h.option.hidden()) {
                return;
            }
            out.print(' ');
            if (!h.option.required()) {
                out.print('[');
            }
            out.print(h.getNameAndMeta(null, this.parserProperties));
            if (h.option.isMultiValued()) {
                out.print(" ...");
            }
            if (!h.option.required()) {
                out.print(']');
            }
        }
    }
}

