/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.JCloudsGetTemplateCommand;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.cli.Replacements;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import jenkins.plugins.jclouds.internal.CredentialsHelper;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

@Extension
public class JCloudsGetCloudCommand
extends CLICommand {
    @Argument(required=true, metaVar="PROFILE", usage="Name of jclouds profile to use.")
    public String profile = null;
    @Option(required=false, name="-f", aliases={"--full"}, usage="Include all templates of this cloud in the export.")
    private boolean full;
    @Option(required=false, name="-r", aliases={"--replace"}, usage="Read replacements as XML from stdin.")
    private boolean replace;

    public String getShortDescription() {
        return Messages.GetCloudCommand_shortDescription();
    }

    protected int run() throws IOException, CmdLineException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JCloudsCloud c = CliHelper.resolveCloud(this.profile, false);
        String xml = Jenkins.XSTREAM.toXML((Object)c);
        try {
            String hash = CredentialsHelper.getCredentialsHash(c.getCloudGlobalKeyId());
            xml = xml.replaceAll("<cloudGlobalKeyId>", String.format("<cloudGlobalKeyId sha256=\"%s\">", hash));
            hash = CredentialsHelper.getCredentialsHash(c.getCloudCredentialsId());
            xml = xml.replaceAll("<cloudCredentialsId>", String.format("<cloudCredentialsId sha256=\"%s\">", hash));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not calculate hashes for credentials");
        }
        if (this.full) {
            StringBuffer sb = new StringBuffer();
            for (JCloudsSlaveTemplate tpl : c.getTemplates()) {
                sb.append(JCloudsGetTemplateCommand.getXmlWithHashes(tpl)).append("\n");
            }
            sb = new StringBuffer(sb.toString().replace("\n", "\n    "));
            sb.insert(0, "<templates>\n    ").replace(sb.length() - 2, sb.length(), "</templates>");
            xml = xml.replaceFirst("(?s)<templates>.*</templates>", Matcher.quoteReplacement(sb.toString()));
        } else {
            xml = xml.replaceFirst("(?s)<templates>.*</templates>", "<templates/>");
        }
        xml = this.replace(xml);
        this.stdout.println("<?xml version='1.1' encoding='UTF-8'?>");
        this.stdout.println(xml);
        return 0;
    }

    private String replace(String xml) throws IOException {
        if (this.replace) {
            String rxml = new String(this.stdin.readAllBytes(), StandardCharsets.UTF_8);
            xml = new Replacements(rxml).replace(xml);
        }
        return xml;
    }
}

