/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Computer;
import hudson.model.Node;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliMessages;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsComputer;
import jenkins.plugins.jclouds.compute.JCloudsSlave;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Localizable;

@Extension
public class JCloudsExpireCommand
extends CLICommand {
    @Argument(required=true, metaVar="NODENAME", index=0, usage="The name of the node to be expired.")
    public String nodeName;

    public String getShortDescription() {
        return Messages.ExpireCommand_shortDescription();
    }

    protected int run() throws CmdLineException {
        JCloudsSlave s;
        Node n = Jenkins.get().getNode(this.nodeName);
        CmdLineParser p = this.getCmdLineParser();
        if (null == n) {
            throw new CmdLineException(p, (Localizable)CliMessages.NO_SUCH_NODE_EXISTS, new String[]{this.nodeName});
        }
        Jenkins.get().checkPermission(Computer.CONFIGURE);
        Computer c = n.toComputer();
        if (JCloudsComputer.class.isInstance(c)) {
            s = (JCloudsSlave)((JCloudsComputer)c).getNode();
            if (null == s) {
                throw new CmdLineException(p, (Localizable)CliMessages.NODE_NOT_FROM_JCLOUDS, new String[]{this.nodeName});
            }
        } else {
            throw new CmdLineException(p, (Localizable)CliMessages.NODE_NOT_FROM_JCLOUDS, new String[]{this.nodeName});
        }
        s.setOverrideRetentionTime(0);
        return 0;
    }
}

