/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import com.thoughtworks.xstream.XStreamException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.ItemGroup;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.config.ConfigExport;
import jenkins.plugins.jclouds.config.ConfigHelper;
import jenkins.plugins.jclouds.config.UserDataBoothook;
import jenkins.plugins.jclouds.config.UserDataInclude;
import jenkins.plugins.jclouds.config.UserDataIncludeOnce;
import jenkins.plugins.jclouds.config.UserDataPartHandler;
import jenkins.plugins.jclouds.config.UserDataScript;
import jenkins.plugins.jclouds.config.UserDataUpstart;
import jenkins.plugins.jclouds.config.UserDataYaml;
import jenkins.plugins.jclouds.internal.CryptoHelper;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.plugins.configfiles.ConfigFiles;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;

@Extension
public class JCloudsCreateUserdataCommand
extends CLICommand {
    private static final String REPL_FMT = "  <replacement old=\"%s\" new=\"%s\"/>%n";
    @Option(name="--overwrite", forbids={"--merge"}, usage="Overwrite existing userdata files.")
    private boolean overwrite;
    @Option(name="--merge", forbids={"--overwrite"}, usage="Generate new Ids for imported userdata files if the id already exists and references different user data.")
    private boolean merge;
    @Argument(required=false, metaVar="CREDENTIAL", usage="ID of credential (Must be an RSA SSH credential) to encrypt data. Default: Taken from input XML.")
    private String cred = null;

    public String getShortDescription() {
        return Messages.CreateUserdataCommand_shortDescription();
    }

    protected int run() throws IOException, CmdLineException {
        ConfigExport ce;
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        String xml = new String(this.stdin.readAllBytes(), StandardCharsets.UTF_8);
        try {
            ce = (ConfigExport)Jenkins.XSTREAM.fromXML(xml);
        }
        catch (XStreamException e) {
            throw new IllegalStateException("Unable to parse input: " + e.toString());
        }
        ArrayList<Config> cfgs = ce.configData;
        if (null != ce.getEncryptedConfigData()) {
            if (null == this.cred) {
                this.cred = ce.credentialsId;
            }
            CryptoHelper ch = new CryptoHelper(this.cred);
            xml = ch.decrypt(ce.getEncryptedConfigData());
            try {
                cfgs = (ArrayList<Config>)Jenkins.XSTREAM.fromXML(xml);
            }
            catch (XStreamException e) {
                throw new IllegalStateException("Unable to parse input: " + e.toString());
            }
        }
        if (this.merge) {
            try {
                Map<String, String> existingHashes = ConfigHelper.getUserDataHashesFromConfigs(ConfigHelper.getJCloudsConfigs());
                Map<String, String> newHashes = ConfigHelper.getUserDataHashesFromConfigs(cfgs);
                ArrayList<Config> newCfgs = new ArrayList<Config>();
                StringBuilder repl = new StringBuilder();
                block6: for (Config cfg : cfgs) {
                    String oHash = existingHashes.get(cfg.id);
                    String nHash = newHashes.get(cfg.id);
                    if (null != oHash && oHash.equals(nHash)) continue;
                    if (null != oHash && !oHash.equals(nHash)) {
                        Config ncfg = this.dupCfg(cfg);
                        newCfgs.add(ncfg);
                        repl.append(String.format(REPL_FMT, cfg.id, ncfg.id));
                        continue;
                    }
                    if (null == oHash) {
                        for (Map.Entry<String, String> entry : existingHashes.entrySet()) {
                            if (!entry.getValue().equals(nHash)) continue;
                            repl.append(String.format(REPL_FMT, cfg.id, entry.getKey()));
                            continue block6;
                        }
                        continue;
                    }
                    newCfgs.add(cfg);
                }
                if (!repl.isEmpty()) {
                    repl.insert(0, String.format("<replacements>%n", new Object[0])).append("</replacements>");
                    this.stdout.println(repl.toString());
                }
                cfgs = newCfgs;
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Could not calculate hashes for userdata");
            }
        }
        if (!this.overwrite) {
            StringBuilder sb = new StringBuilder();
            for (Config cfg : cfgs) {
                if (null == ConfigFiles.getByIdOrNull((ItemGroup)Jenkins.get(), (String)cfg.id)) continue;
                sb.append(String.format("Config data with id %s already exists%n", cfg.id));
            }
            if (sb.length() > 0) {
                throw new IllegalStateException(sb.toString());
            }
        }
        GlobalConfigFiles store = GlobalConfigFiles.get();
        for (Config cfg : cfgs) {
            store.save(cfg);
        }
        return 0;
    }

    private Config dupCfg(Config cfg) {
        Config ncfg = null;
        if (cfg instanceof UserDataBoothook) {
            ncfg = ((UserDataBoothook)cfg).dup();
        }
        if (cfg instanceof UserDataInclude) {
            ncfg = ((UserDataInclude)cfg).dup();
        }
        if (cfg instanceof UserDataIncludeOnce) {
            ncfg = ((UserDataIncludeOnce)cfg).dup();
        }
        if (cfg instanceof UserDataPartHandler) {
            ncfg = ((UserDataPartHandler)cfg).dup();
        }
        if (cfg instanceof UserDataScript) {
            ncfg = ((UserDataScript)cfg).dup();
        }
        if (cfg instanceof UserDataUpstart) {
            ncfg = ((UserDataUpstart)cfg).dup();
        }
        if (cfg instanceof UserDataYaml) {
            ncfg = ((UserDataYaml)cfg).dup();
        }
        if (null == ncfg) {
            throw new IllegalStateException(String.format("Invalid config type! Please report BUG at %s", Messages.BUGURL()));
        }
        return ncfg;
    }
}

