/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import com.thoughtworks.xstream.XStreamException;
import hudson.Extension;
import hudson.cli.CLICommand;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class JCloudsCreateTemplateCommand
extends CLICommand {
    @Argument(required=false, metaVar="PROFILE", index=1, usage="Name of destination jclouds profile. Required, if multiple profiles exist.")
    public String profile = null;
    @Argument(metaVar="NAME", usage="Name of the new template to create.", required=true)
    public String name;
    @Option(required=false, name="-v", aliases={"--verbose"}, usage="Be verbose when validating references to credentials and config files.")
    private boolean verbose;

    public String getShortDescription() {
        return Messages.CreateTemplateCommand_shortDescription();
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (CliHelper.getAllJCloudClouds().size() == 0) {
            throw new IllegalStateException("At least one jclouds profile must exist to create a template");
        }
        JCloudsCloud c = CliHelper.resolveCloud(this.profile, true);
        if (null == c) {
            if (null == this.profile && CliHelper.getAllJCloudClouds().size() > 1) {
                throw new IllegalStateException("More than one JCloudsCloud exists. Please specify target profile");
            }
            return 0;
        }
        if (null != c.getTemplate(this.name)) {
            throw new IllegalStateException("Template '" + this.name + "' already exists");
        }
        String xml = new String(this.stdin.readAllBytes(), StandardCharsets.UTF_8);
        xml = xml.replaceFirst("<name>.*</name>", "<name>" + this.name + "</name>");
        JCloudsSlaveTemplate tpl = null;
        try {
            tpl = (JCloudsSlaveTemplate)((Object)Jenkins.XSTREAM.fromXML(xml));
        }
        catch (XStreamException e) {
            throw new IllegalStateException("Unable to parse input: " + e.toString());
        }
        CliHelper.validateTemplate(tpl, xml, this.verbose ? this.stdout : CliHelper.getDevNull());
        c.addTemplate(tpl);
        return 0;
    }
}

