/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import com.thoughtworks.xstream.XStreamException;
import hudson.Extension;
import hudson.cli.CLICommand;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class JCloudsCreateCloudCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Name of the new jclouds profile to create.", required=true)
    public String name;
    @Option(required=false, name="-v", aliases={"--verbose"}, usage="Be verbose when validating references to credentials and config files.")
    private boolean verbose;

    public String getShortDescription() {
        return Messages.CreateCloudCommand_shortDescription();
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (null != Jenkins.get().clouds.getByName(this.name)) {
            throw new IllegalStateException("Cloud '" + this.name + "' already exists");
        }
        String xml = new String(this.stdin.readAllBytes(), StandardCharsets.UTF_8);
        xml = xml.replaceFirst("<name>.*</name>", "<name>" + this.name + "</name>");
        JCloudsCloud c = null;
        try {
            c = (JCloudsCloud)((Object)Jenkins.XSTREAM.fromXML(xml));
        }
        catch (XStreamException e) {
            throw new IllegalStateException("Unable to parse input: " + e.toString());
        }
        PrintStream devnull = CliHelper.getDevNull();
        CliHelper.validateCloudCredentials(c, xml, this.verbose ? this.stdout : devnull);
        for (JCloudsSlaveTemplate tpl : c.getTemplates()) {
            CliHelper.validateTemplate(tpl, xml, this.verbose ? this.stdout : devnull);
            tpl.setCloud(c);
        }
        Jenkins.get().clouds.add((Object)c);
        return 0;
    }
}

