/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import com.thoughtworks.xstream.XStreamException;
import hudson.Extension;
import hudson.cli.CLICommand;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import org.kohsuke.args4j.Argument;

@Extension
public class JCloudsCopyTemplateCommand
extends CLICommand {
    @Argument(metaVar="FROM-TEMPLATE", index=0, usage="Name of the existing template to copy.", required=true)
    public String from;
    @Argument(metaVar="TO-TEMPLATE", index=1, usage="Name of the new template to create.", required=true)
    public String to;
    @Argument(required=false, metaVar="PROFILE", index=2, usage="Name of jclouds profile. Required, if FROM-TEMPLATE is ambiguous.")
    public String profile = null;

    public String getShortDescription() {
        return Messages.CopyTemplateCommand_shortDescription();
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JCloudsCloud c = CliHelper.resolveCloud(this.profile, true);
        if (this.from.equals(this.to)) {
            throw new IllegalStateException("Cannot copy template to itself");
        }
        JCloudsSlaveTemplate tplFrom = CliHelper.resolveTemplate(c, this.from);
        if (null != (c = tplFrom.getCloud()).getTemplate(this.to)) {
            throw new IllegalStateException("Template '" + this.to + "' already exists");
        }
        String xml = Jenkins.XSTREAM.toXML((Object)tplFrom);
        xml = xml.replaceFirst("<name>.*</name>", "<name>" + this.to + "</name>");
        try {
            JCloudsSlaveTemplate tplTo = (JCloudsSlaveTemplate)((Object)Jenkins.XSTREAM.fromXML(xml));
            c.addTemplate(tplTo);
        }
        catch (XStreamException e) {
            throw new IllegalStateException("Unable to copy " + e.toString());
        }
        return 0;
    }
}

