/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import com.thoughtworks.xstream.XStreamException;
import hudson.Extension;
import hudson.cli.CLICommand;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliHelper;
import jenkins.plugins.jclouds.cli.Messages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import org.kohsuke.args4j.Argument;

@Extension
public class JCloudsCopyCloudCommand
extends CLICommand {
    @Argument(metaVar="FROM-CLOUD", index=0, usage="Name of the existing jclouds profile to copy.", required=true)
    public String from;
    @Argument(metaVar="TO-CLOUD", index=1, usage="Name of the new jclouds profile to create.", required=true)
    public String to;

    public String getShortDescription() {
        return Messages.CopyCloudCommand_shortDescription();
    }

    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        JCloudsCloud cFrom = CliHelper.resolveCloud(this.from, false);
        if (this.from.equals(this.to)) {
            throw new IllegalStateException("Cannot copy cloud to itself");
        }
        if (null != Jenkins.get().clouds.getByName(this.to)) {
            throw new IllegalStateException("Cloud '" + this.to + "' already exists");
        }
        String xml = Jenkins.XSTREAM.toXML((Object)cFrom);
        xml = xml.replaceFirst("<name>.*</name>", "<name>" + this.to + "</name>");
        try {
            JCloudsCloud cTo = (JCloudsCloud)((Object)Jenkins.XSTREAM.fromXML(xml));
            Jenkins.get().clouds.add((Object)cTo);
        }
        catch (XStreamException e) {
            throw new IllegalStateException("Unable to copy " + e.toString());
        }
        return 0;
    }
}

