/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.cli;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Hudson;
import hudson.slaves.Cloud;
import hudson.util.EditDistance;
import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.cli.CliMessages;
import jenkins.plugins.jclouds.compute.JCloudsCloud;
import jenkins.plugins.jclouds.compute.JCloudsSlaveTemplate;
import jenkins.plugins.jclouds.config.ConfigHelper;
import jenkins.plugins.jclouds.internal.CredentialsHelper;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Localizable;

class CliHelper {
    public static final String XML_HEADER = "<?xml version='1.1' encoding='UTF-8'?>";

    CliHelper() {
    }

    public static List<JCloudsCloud> getAllJCloudClouds() {
        ArrayList<JCloudsCloud> ret = new ArrayList<JCloudsCloud>();
        for (Cloud c : Jenkins.get().clouds) {
            if (!(c instanceof JCloudsCloud)) continue;
            ret.add((JCloudsCloud)c);
        }
        return ret;
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Dont care for nullOutputStream")
    public static PrintStream getDevNull() {
        return new PrintStream(PrintStream.nullOutputStream());
    }

    public static JCloudsCloud resolveCloud(String name, boolean optional) throws CmdLineException {
        List<JCloudsCloud> cl;
        if (null != name) {
            Hudson.CloudList cl2 = Jenkins.get().clouds;
            Cloud c = cl2.getByName(name);
            if (null != c && c instanceof JCloudsCloud) {
                return (JCloudsCloud)c;
            }
            ArrayList<String> names = new ArrayList<String>();
            for (Cloud cloud : Jenkins.get().clouds) {
                String n;
                if (!(cloud instanceof JCloudsCloud) || (n = ((JCloudsCloud)cloud).profile).length() <= 0) continue;
                names.add(n);
            }
            throw new CmdLineException(null, (Localizable)CliMessages.NO_SUCH_PROFILE_EXISTS, new String[]{name, EditDistance.findNearest((String)name, names)});
        }
        if (optional && (cl = CliHelper.getAllJCloudClouds()).size() == 1) {
            return cl.get(0);
        }
        return null;
    }

    public static List<String> getAllTemplateNames(JCloudsCloud cloud) {
        ArrayList<String> ret = new ArrayList<String>();
        if (null == cloud) {
            for (Cloud c : Jenkins.get().clouds) {
                if (!(c instanceof JCloudsCloud)) continue;
                JCloudsCloud jc = (JCloudsCloud)c;
                for (JCloudsSlaveTemplate t : jc.getTemplates()) {
                    if (ret.contains(t.name)) continue;
                    ret.add(t.name);
                }
            }
            return ret;
        }
        for (JCloudsSlaveTemplate t : cloud.getTemplates()) {
            ret.add(t.name);
        }
        return ret;
    }

    public static JCloudsSlaveTemplate resolveTemplate(JCloudsCloud cloud, String name) throws CmdLineException {
        JCloudsSlaveTemplate ret = null;
        if (null == cloud) {
            for (Cloud c : Jenkins.get().clouds) {
                JCloudsCloud jc;
                JCloudsSlaveTemplate t;
                if (!(c instanceof JCloudsCloud) || null == (t = (jc = (JCloudsCloud)c).getTemplate(name))) continue;
                if (null != ret) {
                    throw new CmdLineException(null, (Localizable)CliMessages.AMBIGUOUS_TEMPLATE, new String[]{name});
                }
                ret = t;
            }
        } else {
            ret = cloud.getTemplate(name);
        }
        if (null == ret) {
            List<String> names = CliHelper.getAllTemplateNames(cloud);
            throw new CmdLineException(null, (Localizable)CliMessages.NO_SUCH_TEMPLATE_EXISTS, new String[]{name, EditDistance.findNearest((String)name, names)});
        }
        return ret;
    }

    public static String getHashAttribute(String xml, String tag) {
        Pattern p = Pattern.compile(String.format("(?s).*?<%s sha256=\"([0-9a-fA-F]+)\">.*", tag));
        Matcher m = p.matcher(xml);
        if (m.matches()) {
            return m.group(1);
        }
        return "";
    }

    private static String getHashAttribute(String xml, String tag, String id) {
        Pattern p = Pattern.compile(String.format("(?s).*?<%s sha256=\"([0-9a-fA-F]+)\">%s.*", tag, id));
        Matcher m = p.matcher(xml);
        if (m.matches()) {
            return m.group(1);
        }
        return "";
    }

    public static void validateTemplate(JCloudsSlaveTemplate tpl, String xml, PrintStream verbose) {
        CliHelper.validateTemplateCredentials(tpl, xml, verbose);
        CliHelper.validateUserData(tpl, xml, verbose);
    }

    private static void validateTemplateCredentials(JCloudsSlaveTemplate tpl, String xml, PrintStream verbose) {
        String id = tpl.getCredentialsId();
        if (null == CredentialsHelper.getCredentialsById(id)) {
            throw new IllegalStateException(String.format("credentialsId %s of template %s does not resolve", id, tpl.name));
        }
        try {
            String hash = CredentialsHelper.getCredentialsHash(id);
            String ohash = CliHelper.getHashAttribute(xml, "credentialsId", id);
            if (!ohash.isEmpty()) {
                if (!hash.equalsIgnoreCase(ohash)) {
                    throw new IllegalStateException(String.format("credentialsId %s of template %s resolves to a different credential", id, tpl.name));
                }
                verbose.println(String.format("Validated credentialsId %s of template %s", id, tpl.name));
            } else {
                verbose.println(String.format("Found credentialsId %s of template %s", id, tpl.name));
            }
            id = tpl.getAdminCredentialsId();
            if (null != id) {
                if (null == CredentialsHelper.getCredentialsById(id)) {
                    throw new IllegalStateException(String.format("adminCredentialsId %s of template %s does not resolve", id, tpl.name));
                }
                hash = CredentialsHelper.getCredentialsHash(id);
                ohash = CliHelper.getHashAttribute(xml, "adminCredentialsId", id);
                if (!ohash.isEmpty()) {
                    if (!hash.equalsIgnoreCase(ohash)) {
                        throw new IllegalStateException(String.format("adminCredentialsId %s of template %s resolves to a different credential", id, tpl.name));
                    }
                    verbose.println(String.format("Validated adminCredentialsId %s of template %s", id, tpl.name));
                } else {
                    verbose.println(String.format("Found adminCredentialsId %s of template %s", id, tpl.name));
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not calculate hashes for credentials of template " + tpl.name);
        }
    }

    private static void validateUserData(JCloudsSlaveTemplate tpl, String xml, PrintStream verbose) {
        try {
            List<String> ids = tpl.getUserDataIds();
            Map<String, String> m = ConfigHelper.getUserDataHashes(ids);
            for (String id : ids) {
                String hash = m.get(id);
                if (null == hash) {
                    throw new IllegalStateException(String.format("fileId %s in template %s does not resolve", id, tpl.name));
                }
                String ohash = CliHelper.getHashAttribute(xml, "fileId", id);
                if (!ohash.isEmpty()) {
                    if (!hash.equalsIgnoreCase(ohash)) {
                        throw new IllegalStateException(String.format("fileId %s in template %s resolves to a different config file", id, tpl.name));
                    }
                    verbose.println(String.format("Validated fileId %s of template %s", id, tpl.name));
                    continue;
                }
                verbose.println(String.format("Found fileId %s of template %s", id, tpl.name));
            }
            String sid = tpl.getInitScriptId();
            if (null != sid && !sid.isEmpty()) {
                m = ConfigHelper.getUserDataHashes(List.of(sid));
                String hash = m.get(sid);
                String ohash = CliHelper.getHashAttribute(xml, "initScriptId", sid);
                if (!ohash.isEmpty()) {
                    if (!hash.equalsIgnoreCase(ohash)) {
                        throw new IllegalStateException(String.format("initScriptId %s in template %s resolves to a different config file", sid, tpl.name));
                    }
                    verbose.println(String.format("Validated initScriptId %s of template %s", sid, tpl.name));
                } else {
                    verbose.println(String.format("Found initScriptId %s of template %s", sid, tpl.name));
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not calculate hashes for userdata of template " + tpl.name);
        }
    }

    public static void validateCloudCredentials(JCloudsCloud c, String xml, PrintStream verbose) {
        String id = c.getCloudGlobalKeyId();
        if (null == CredentialsHelper.getCredentialsById(id)) {
            throw new IllegalStateException(String.format("cloudGlobalKeyId %s does not resolve", id));
        }
        try {
            String hash = CredentialsHelper.getCredentialsHash(id);
            String ohash = CliHelper.getHashAttribute(xml, "cloudGlobalKeyId");
            if (ohash.isEmpty()) {
                verbose.println(String.format("Found cloudGlobalKeyId %s of cloud %s", id, c.name));
            } else {
                if (!hash.equalsIgnoreCase(ohash)) {
                    throw new IllegalStateException(String.format("cloudGlobalKeyId %s resolves to a different credential", id));
                }
                verbose.println(String.format("Validated cloudGlobalKeyId %s of cloud %s", id, c.name));
            }
            id = c.getCloudCredentialsId();
            if (null == CredentialsHelper.getCredentialsById(id)) {
                throw new IllegalStateException(String.format("cloudCredentialsId %s does not resolve", id));
            }
            hash = CredentialsHelper.getCredentialsHash(id);
            ohash = CliHelper.getHashAttribute(xml, "cloudCredentialsId");
            if (ohash.isEmpty()) {
                verbose.println(String.format("Found cloudCredentialsId %s of cloud %s", id, c.name));
            } else {
                if (!hash.equalsIgnoreCase(ohash)) {
                    throw new IllegalStateException(String.format("cloudCredentialsId %s resolves to a different credential", id));
                }
                verbose.println(String.format("Validated cloudCredentialsId %s of cloud %s", id, c.name));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not calculate hashes for credentials");
        }
    }
}

