/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.blobstore;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.CopyOnWriteList;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.blobstore.BlobStoreEntry;
import jenkins.plugins.jclouds.blobstore.BlobStoreProfile;
import net.sf.json.JSONObject;
import org.jclouds.rest.AuthorizationException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class BlobStorePublisher
extends Recorder
implements Describable<Publisher> {
    private static final Logger LOGGER = Logger.getLogger(BlobStorePublisher.class.getName());
    private String profileName;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private final List<BlobStoreEntry> entries;

    @DataBoundConstructor
    public BlobStorePublisher(String profileName, List<BlobStoreEntry> entries) {
        BlobStoreProfile[] sites;
        if (profileName == null && (sites = DESCRIPTOR.getProfiles()).length > 0) {
            profileName = sites[0].getProfileName();
        }
        this.entries = entries;
        this.profileName = profileName;
    }

    public List<BlobStoreEntry> getEntries() {
        return this.entries;
    }

    public BlobStoreProfile getProfile() {
        BlobStoreProfile[] profiles = DESCRIPTOR.getProfiles();
        if (this.profileName == null && profiles.length > 0) {
            return profiles[0];
        }
        for (BlobStoreProfile profile : profiles) {
            if (!profile.getProfileName().equals(this.profileName)) continue;
            return profile;
        }
        return null;
    }

    public String getName() {
        return this.profileName;
    }

    public void setName(String profileName) {
        this.profileName = profileName;
    }

    private void log(BuildListener listener, String message) {
        listener.getLogger().println(((Object)((Object)this)).getClass().getSimpleName() + ": " + message);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        BlobStoreProfile blobStoreProfile = this.getProfile();
        if (blobStoreProfile == null) {
            this.log(listener, "No BlobStore profile is configured.");
            build.setResult(Result.FAILURE);
            return true;
        }
        this.log(listener, "using BlobStore profile: " + blobStoreProfile.getProfileName());
        try {
            EnvVars envVars = build.getEnvironment((TaskListener)listener);
            for (BlobStoreEntry bse : this.entries) {
                Result res = build.getResult();
                if (bse.onlyIfSuccessful && null != res && res.isWorseThan(Result.UNSTABLE)) {
                    this.log(listener, "Skip publishing entry, because build is not successful");
                    continue;
                }
                String xSource = Util.replaceMacro((String)bse.sourceFile, (Map)envVars);
                String xContainer = Util.replaceMacro((String)bse.container, (Map)envVars);
                FilePath ws = build.getWorkspace();
                if (null != ws) {
                    FilePath[] paths = ws.list(xSource);
                    String wsPath = ws.getRemote();
                    if (paths.length == 0) {
                        String error = ws.validateAntFileMask(xSource, Integer.MAX_VALUE);
                        if (error != null) {
                            this.log(listener, error);
                        }
                        if (bse.allowEmptyFileset) {
                            this.log(listener, "Ignoring empty file set for pattern: " + xSource);
                        } else {
                            this.log(listener, "Failing build");
                            build.setResult(Result.FAILURE);
                        }
                    }
                    for (FilePath src : paths) {
                        String xPath = this.getDestinationPath(bse.path, bse.keepHierarchy, wsPath, src, (Map<String, String>)envVars);
                        this.log(listener, String.format("Publishing \"%s\" to container \"%s\", path \"%s\"", src.getName(), xContainer, xPath));
                        blobStoreProfile.upload(xContainer, xPath, src);
                    }
                    continue;
                }
                this.log(listener, "Unable to fetch workspace (NULL)");
                build.setResult(Result.FAILURE);
            }
        }
        catch (AuthorizationException e) {
            LOGGER.severe("Failed to upload files to Blob Store due to authorization exception.");
            RuntimeException overrideException = new RuntimeException("Failed to publish files due to authorization exception.");
            overrideException.printStackTrace(listener.error("Failed to publish files"));
            build.setResult(Result.FAILURE);
        }
        catch (IOException e) {
            LOGGER.severe("Failed to publish files: " + e.getMessage());
            e.printStackTrace(listener.error("Failed to publish files"));
            build.setResult(Result.FAILURE);
        }
        return true;
    }

    private String getDestinationPath(String path, boolean appendFilePath, String wsPath, FilePath file, Map<String, String> envVars) {
        Object resultPath;
        String expandedPath = "";
        String relativeFilePath = "";
        FilePath parent = file.getParent();
        if (parent == null) {
            throw new IllegalStateException("No parent directory to workspace, normally occurs if the workspace is set to the root of the file system, don't do this...");
        }
        String fileFullPath = parent.getRemote();
        if (path != null && !path.equals("") && (expandedPath = Util.replaceMacro((String)path, envVars)).endsWith("/")) {
            expandedPath = expandedPath.substring(0, expandedPath.length() - 1);
        }
        if (appendFilePath && fileFullPath.startsWith(wsPath) && (relativeFilePath = fileFullPath.substring(wsPath.length())).startsWith("/")) {
            relativeFilePath = relativeFilePath.substring(1);
        }
        if (((String)(resultPath = !expandedPath.equals("") && !relativeFilePath.equals("") ? expandedPath + "/" + relativeFilePath : expandedPath + relativeFilePath)).startsWith("/")) {
            resultPath = ((String)resultPath).substring(1);
        }
        if (((String)resultPath).endsWith("/")) {
            resultPath = ((String)resultPath).substring(0, ((String)resultPath).length() - 1);
        }
        return ((String)resultPath).replaceAll("//+", "/").replaceAll("/\\.+/", "/");
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private final CopyOnWriteList<BlobStoreProfile> profiles = new CopyOnWriteList();

        public DescriptorImpl(Class<? extends Publisher> clazz) {
            super(clazz);
            this.load();
        }

        public DescriptorImpl() {
            this(BlobStorePublisher.class);
        }

        public String getDisplayName() {
            return "Publish artifacts to JClouds BlobStore";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            this.setProfiles(req.bindJSONToList(BlobStoreProfile.class, formData.get("profiles")));
            this.save();
            return true;
        }

        public void setProfiles(List<BlobStoreProfile> newProfiles) {
            this.profiles.replaceBy(newProfiles);
        }

        public BlobStoreProfile[] getProfiles() {
            return (BlobStoreProfile[])this.profiles.toArray((Object[])new BlobStoreProfile[0]);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return this.profiles != null && !this.profiles.isEmpty();
        }

        @POST
        public ListBoxModel doFillProfileNameItems(@AncestorInPath AbstractProject project) {
            if (null == project) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Permission.CONFIGURE);
            }
            ListBoxModel model = new ListBoxModel();
            for (BlobStoreProfile profile : this.getProfiles()) {
                model.add(profile.getProfileName());
            }
            return model;
        }
    }
}

