/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jclouds.blobstore;

import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.inject.Module;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.jclouds.blobstore.BlobStoreLogger;
import jenkins.plugins.jclouds.internal.CredentialsHelper;
import jenkins.plugins.jclouds.internal.LocationHelper;
import jenkins.plugins.jclouds.modules.JenkinsConfigurationModule;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.Apis;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.logging.jdk.config.JDKLoggingModule;
import org.jclouds.providers.Providers;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class BlobStoreProfile
extends AbstractDescribableImpl<BlobStoreProfile> {
    private static final Logger LOGGER = Logger.getLogger(BlobStoreProfile.class.getName());
    private final String profileName;
    private final String providerName;
    private final String endPointUrl;
    private final String locationId;
    private String credentialsId;
    private final boolean trustAll;
    @Deprecated
    private final transient String identity;
    @Deprecated
    private final transient String credential;
    static final Iterable<Module> MODULES = ImmutableSet.of((Object)new JDKLoggingModule(){

        public Logger.LoggerFactory createLoggerFactory() {
            return new BlobStoreLogger.Factory();
        }
    }, (Object)((Object)new JenkinsConfigurationModule()));

    @DataBoundConstructor
    public BlobStoreProfile(String profileName, String providerName, String credentialsId, String endPointUrl, String locationId, boolean trustAll) {
        this.profileName = profileName;
        this.providerName = providerName;
        this.credentialsId = credentialsId;
        this.endPointUrl = endPointUrl;
        this.locationId = locationId;
        this.trustAll = trustAll;
        this.identity = null;
        this.credential = null;
    }

    public boolean getTrustAll() {
        return this.trustAll;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getEndPointUrl() {
        return this.endPointUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String value) {
        this.credentialsId = value;
    }

    public String getLocationId() {
        return this.locationId;
    }

    private static BlobStoreContext ctx(String provider, String credId, Properties overrides) {
        Thread.currentThread().setContextClassLoader(Apis.class.getClassLoader());
        CredentialsHelper.setProject(credId, overrides);
        return (BlobStoreContext)CredentialsHelper.setCredentials(ContextBuilder.newBuilder((String)provider), credId).overrides(overrides).modules(MODULES).buildView(BlobStoreContext.class);
    }

    private static Properties buildJCloudsOverrides(String url, boolean relaxed) {
        Properties ret = new Properties();
        if (null != url && !url.isEmpty()) {
            ret.setProperty("jclouds.endpoint", url);
        }
        if (relaxed) {
            ret.put("jclouds.trust-all-certs", "true");
            ret.put("jclouds.relax-hostname", "true");
        }
        return ret;
    }

    static BlobStoreContext ctx(String provider, String credId, String url, boolean relaxed) {
        return BlobStoreProfile.ctx(provider, credId, BlobStoreProfile.buildJCloudsOverrides(url, relaxed));
    }

    public void upload(String container, String path, FilePath filePath) throws IOException, InterruptedException {
        if (filePath.isDirectory()) {
            throw new IOException(String.valueOf(filePath) + " is a directory");
        }
        try (BlobStoreContext bsc = BlobStoreProfile.ctx(this.providerName, this.credentialsId, this.endPointUrl, this.trustAll);){
            BlobStore blobStore = bsc.getBlobStore();
            String locId = Util.fixEmptyAndTrim((String)this.locationId);
            Location location = null;
            if (null != locId) {
                for (Location loc : blobStore.listAssignableLocations()) {
                    if (!loc.getId().equals(locId)) continue;
                    location = loc;
                    break;
                }
            }
            if (blobStore.createContainerInLocation(location, container)) {
                LOGGER.info("Created container " + container);
            }
            Object destPath = path.isEmpty() ? filePath.getName() : path + "/" + filePath.getName();
            LOGGER.info("Publishing now to container: " + container + " path: " + (String)destPath);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            DigestInputStream dis = new DigestInputStream(filePath.read(), md5);
            Blob blob = blobStore.blobBuilder((String)destPath).payload((InputStream)dis).contentLength(filePath.length()).build();
            blobStore.putBlob(container, blob);
            bsc.close();
            String md5local = Util.toHexString((byte[])md5.digest()).toLowerCase();
            while (true) {
                try (BlobStoreContext bsc2 = BlobStoreProfile.ctx(this.providerName, this.credentialsId, this.endPointUrl, this.trustAll);){
                    blobStore = bsc2.getBlobStore();
                    LOGGER.info("Fetching remote MD5sum for " + (String)destPath);
                    String md5remote = blobStore.blobMetadata(container, (String)destPath).getContentMetadata().getContentMD5AsHashCode().toString();
                    if (md5local.equals(md5remote)) {
                        LOGGER.info("Published " + (String)destPath + " to container " + container + " with profile " + this.profileName);
                        break;
                    }
                    LOGGER.warning("MD5 mismatch while publishing " + (String)destPath + " to container " + container + " with profile " + this.profileName);
                    throw new IOException("MD5 mismatch while publishing");
                }
                catch (IllegalStateException ise) {
                    if (!ise.getMessage().contains("absent value")) {
                        throw ise;
                    }
                    Thread.sleep(1000L);
                    continue;
                }
                break;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("MD5 not installed (should never happen).");
        }
    }

    @Restricted(value={DoNotUse.class})
    public static class ConverterImpl
    extends XStream2.PassthruConverter<BlobStoreProfile> {
        static final Logger LOGGER = Logger.getLogger(ConverterImpl.class.getName());

        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(BlobStoreProfile bsp, UnmarshallingContext context) {
            if ((null == bsp.getCredentialsId() || bsp.getCredentialsId().isEmpty()) && null != bsp.identity && !bsp.identity.isEmpty()) {
                String description = "JClouds BlobStore " + bsp.profileName + " - auto-migrated";
                bsp.setCredentialsId(CredentialsHelper.convertCredentials(description, bsp.identity, Secret.fromString((String)bsp.credential)));
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<BlobStoreProfile> {
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckProfileName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckProviderName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckCredentialsId(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckEndPointUrl(@QueryParameter String value) {
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String currentValue) {
            if (!(context instanceof AccessControlled ? (AccessControlled)context : Jenkins.get()).hasPermission(Computer.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(currentValue);
            }
            return new StandardUsernameListBoxModel().includeAs(ACL.SYSTEM2, context, StandardUsernameCredentials.class).includeCurrentValue(currentValue);
        }

        ImmutableSortedSet<String> getAllProviders() {
            Thread.currentThread().setContextClassLoader(Apis.class.getClassLoader());
            ImmutableSet.Builder builder = ImmutableSet.builder();
            builder.addAll(Iterables.transform((Iterable)Apis.viewableAs(BlobStoreContext.class), (Function)Apis.idFunction()));
            builder.addAll(Iterables.transform((Iterable)Providers.viewableAs(BlobStoreContext.class), (Function)Providers.idFunction()));
            return ImmutableSortedSet.copyOf((Collection)builder.build());
        }

        public String defaultProviderName() {
            return (String)this.getAllProviders().first();
        }

        @POST
        public ListBoxModel doFillProviderNameItems(@AncestorInPath ItemGroup context) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel m = new ListBoxModel();
            for (String supportedProvider : this.getAllProviders()) {
                m.add(supportedProvider, supportedProvider);
            }
            return m;
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="providerName") String provider, @QueryParameter(value="credentialsId") String credId, @QueryParameter(value="endPointUrl") String url, @QueryParameter(value="trustAll") boolean relaxed) throws IOException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (null == Util.fixEmptyAndTrim((String)credId)) {
                return FormValidation.error((String)"BlobStore credentials not specified.");
            }
            FormValidation res = FormValidation.ok((String)"Connection succeeded!");
            try (BlobStoreContext ctx = BlobStoreProfile.ctx(Util.fixEmptyAndTrim((String)provider), credId, Util.fixEmptyAndTrim((String)url), relaxed);){
                ctx.getBlobStore().list();
            }
            catch (Exception ex) {
                res = FormValidation.error((String)("Cannot connect to specified BlobStore, please check the credentials: " + ex.getMessage()));
            }
            return res;
        }

        @POST
        public ListBoxModel doFillLocationIdItems(@QueryParameter String providerName, @QueryParameter String credentialsId, @QueryParameter String endPointUrl) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel m = new ListBoxModel();
            m.add("None specified", "");
            if (null == Util.fixEmptyAndTrim((String)credentialsId)) {
                return m;
            }
            providerName = Util.fixEmptyAndTrim((String)providerName);
            endPointUrl = Util.fixEmptyAndTrim((String)endPointUrl);
            try (BlobStoreContext ctx = BlobStoreProfile.ctx(providerName, credentialsId, endPointUrl, true);){
                LocationHelper.fillLocations(m, ctx.getBlobStore().listAssignableLocations());
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
            return m;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @POST
        public FormValidation doValidateLocationId(@QueryParameter(value="providerName") String provider, @QueryParameter(value="credentialsId") String credId, @QueryParameter(value="endPointUrl") String url, @QueryParameter(value="locationId") String locId) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (null == Util.fixEmptyAndTrim((String)credId)) {
                return FormValidation.error((String)"No cloud credentials provided.");
            }
            if (null == Util.fixEmptyAndTrim((String)provider)) {
                return FormValidation.error((String)"Provider Name shouldn't be empty");
            }
            String testLoc = Util.fixEmptyAndTrim((String)locId);
            if (null == testLoc) {
                return FormValidation.ok((String)"No location configured. jclouds automatically will choose one.");
            }
            FormValidation res = FormValidation.error((String)"Invalid Location Id, please check the value and try again.");
            try (BlobStoreContext ctx = BlobStoreProfile.ctx(provider, credId, url, true);){
                Location location;
                Set locations = ctx.getBlobStore().listAssignableLocations();
                Iterator iterator = locations.iterator();
                do {
                    if (!iterator.hasNext()) return res;
                    location = (Location)iterator.next();
                    if (!location.getId().equals(testLoc)) continue;
                    FormValidation formValidation = FormValidation.ok((String)"Location Id is valid.");
                    return formValidation;
                } while (!location.getId().contains(testLoc));
                FormValidation formValidation = FormValidation.warning((String)("Sorry cannot find the location id, Did you mean: " + location.getId() + "?\n" + String.valueOf(location)));
                return formValidation;
            }
            catch (Exception ex) {
                return FormValidation.error((String)"Unable to check the location id, please check if the credentials you provided are correct.", (Object[])new Object[]{ex});
            }
        }
    }
}

